/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.ext;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.view.window.RandomAccessByIndex;
import com.espertech.esper.view.window.RandomAccessByIndexObserver;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IStreamSortedRandomAccess
implements RandomAccessByIndex {
    private final RandomAccessByIndexObserver updateObserver;
    private TreeMap<MultiKeyUntyped, LinkedList<EventBean>> sortedEvents;
    private int currentSize;
    private Iterator<LinkedList<EventBean>> iterator;
    private EventBean[] cache;
    private int cacheFilledTo;

    public IStreamSortedRandomAccess(RandomAccessByIndexObserver updateObserver) {
        this.updateObserver = updateObserver;
    }

    public void refresh(TreeMap<MultiKeyUntyped, LinkedList<EventBean>> sortedEvents, int currentSize, int maxSize) {
        this.updateObserver.updated(this);
        this.sortedEvents = sortedEvents;
        this.currentSize = currentSize;
        this.iterator = null;
        this.cacheFilledTo = 0;
        if (this.cache == null) {
            this.cache = new EventBean[maxSize];
        }
    }

    @Override
    public EventBean getNewData(int index) {
        if (this.iterator == null) {
            this.iterator = this.sortedEvents.values().iterator();
        }
        if (index >= this.currentSize) {
            return null;
        }
        if (index < this.cacheFilledTo) {
            return this.cache[index];
        }
        while (this.cacheFilledTo != this.currentSize && this.iterator.hasNext()) {
            LinkedList<EventBean> events = this.iterator.next();
            Iterator i$ = events.iterator();
            while (i$.hasNext()) {
                EventBean event;
                this.cache[this.cacheFilledTo] = event = (EventBean)i$.next();
                ++this.cacheFilledTo;
            }
            if (this.cacheFilledTo <= index) continue;
            break;
        }
        if (index <= this.cacheFilledTo) {
            return this.cache[index];
        }
        return null;
    }

    @Override
    public EventBean getOldData(int index) {
        return null;
    }
}

