/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.ext;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.view.window.RandomAccessByIndex;
import com.espertech.esper.view.window.RandomAccessByIndexObserver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IStreamTimeOrderRandomAccess
implements RandomAccessByIndex {
    private final RandomAccessByIndexObserver updateObserver;
    private TreeMap<Long, ArrayList<EventBean>> sortedEvents;
    private int currentSize;
    private Iterator<ArrayList<EventBean>> iterator;
    private ArrayList<EventBean> cache;
    private int cacheFilledTo;

    public IStreamTimeOrderRandomAccess(RandomAccessByIndexObserver updateObserver) {
        this.updateObserver = updateObserver;
    }

    public void refresh(TreeMap<Long, ArrayList<EventBean>> sortedEvents, int currentSize) {
        this.updateObserver.updated(this);
        this.sortedEvents = sortedEvents;
        this.currentSize = currentSize;
        this.iterator = null;
        this.cacheFilledTo = 0;
        if (this.cache == null) {
            this.cache = new ArrayList();
        }
    }

    @Override
    public EventBean getNewData(int index) {
        if (this.iterator == null) {
            this.iterator = this.sortedEvents.values().iterator();
        }
        if (index >= this.currentSize) {
            return null;
        }
        if (index < this.cacheFilledTo) {
            return this.cache.get(index);
        }
        while (this.cacheFilledTo != this.currentSize && this.iterator.hasNext()) {
            ArrayList<EventBean> events = this.iterator.next();
            for (EventBean event : events) {
                this.cache.add(this.cacheFilledTo, event);
                ++this.cacheFilledTo;
            }
            if (this.cacheFilledTo <= index) continue;
            break;
        }
        if (index <= this.cacheFilledTo) {
            return this.cache.get(index);
        }
        return null;
    }

    @Override
    public EventBean getOldData(int index) {
        return null;
    }
}

