/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.ext;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.EPStatementHandleCallback;
import com.espertech.esper.core.ExtensionServicesContext;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.ext.IStreamTimeOrderRandomAccess;
import com.espertech.esper.view.ext.TimeOrderViewFactory;
import com.espertech.esper.view.ext.TimeOrderViewIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeOrderView
extends ViewSupport
implements DataWindowView,
CloneableView {
    private final StatementContext statementContext;
    private final TimeOrderViewFactory timeOrderViewFactory;
    private final ExprNode timestampExpression;
    private final long intervalSize;
    private final IStreamTimeOrderRandomAccess optionalSortedRandomAccess;
    private final ScheduleSlot scheduleSlot;
    private final EPStatementHandleCallback handle;
    private EventBean[] eventsPerStream = new EventBean[1];
    private TreeMap<Long, ArrayList<EventBean>> sortedEvents;
    private boolean isCallbackScheduled;
    private int eventCount;
    private Map<EventBean, ArrayList<EventBean>> reverseIndex;
    private static final Log log = LogFactory.getLog(TimeOrderView.class);

    public TimeOrderView(StatementContext statementContext, TimeOrderViewFactory timeOrderViewFactory, ExprNode timestampExpr, long intervalSize, IStreamTimeOrderRandomAccess optionalSortedRandomAccess, boolean isRemoveStreamHandling) {
        this.statementContext = statementContext;
        this.timeOrderViewFactory = timeOrderViewFactory;
        this.timestampExpression = timestampExpr;
        this.intervalSize = intervalSize;
        this.optionalSortedRandomAccess = optionalSortedRandomAccess;
        this.scheduleSlot = statementContext.getScheduleBucket().allocateSlot();
        if (isRemoveStreamHandling) {
            this.reverseIndex = new HashMap<EventBean, ArrayList<EventBean>>();
        }
        this.sortedEvents = new TreeMap();
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                TimeOrderView.this.expire();
            }
        };
        this.handle = new EPStatementHandleCallback(statementContext.getEpStatementHandle(), callback);
    }

    public ExprNode getTimestampExpression() {
        return this.timestampExpression;
    }

    public long getIntervalSize() {
        return this.intervalSize;
    }

    protected IStreamTimeOrderRandomAccess getOptionalSortedRandomAccess() {
        return this.optionalSortedRandomAccess;
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return this.timeOrderViewFactory.makeView(statementContext);
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Updating view");
            TimeOrderView.dumpUpdateParams("TimeOrderView", newData, oldData);
        }
        EventBean[] postOldEventsArray = null;
        if (newData != null && newData.length > 0) {
            long engineTime = this.statementContext.getSchedulingService().getTime();
            long windowTailTime = engineTime - this.intervalSize + 1L;
            long oldestEvent = Long.MAX_VALUE;
            if (!this.sortedEvents.isEmpty()) {
                oldestEvent = this.sortedEvents.firstKey();
            }
            boolean addedOlderEvent = false;
            ArrayList<EventBean> postOldEvents = null;
            for (int i = 0; i < newData.length; ++i) {
                ArrayList<EventBean> listOfBeans;
                EventBean newEvent;
                this.eventsPerStream[0] = newEvent = newData[i];
                Long timestamp2 = (Long)this.timestampExpression.evaluate(this.eventsPerStream, true, this.statementContext);
                if (timestamp2 < windowTailTime) {
                    if (postOldEvents == null) {
                        postOldEvents = new ArrayList<EventBean>();
                    }
                    postOldEvents.add(newEvent);
                    continue;
                }
                if (timestamp2 < oldestEvent) {
                    addedOlderEvent = true;
                    oldestEvent = timestamp2;
                }
                if ((listOfBeans = this.sortedEvents.get(timestamp2)) != null) {
                    listOfBeans.add(newEvent);
                } else {
                    listOfBeans = new ArrayList();
                    listOfBeans.add(newEvent);
                    this.sortedEvents.put(timestamp2, listOfBeans);
                }
                if (this.reverseIndex != null) {
                    this.reverseIndex.put(newEvent, listOfBeans);
                }
                ++this.eventCount;
            }
            if (!this.sortedEvents.isEmpty()) {
                if (!this.isCallbackScheduled) {
                    long callbackWait = oldestEvent - windowTailTime + 1L;
                    this.statementContext.getSchedulingService().add(callbackWait, (ScheduleHandle)this.handle, this.scheduleSlot);
                    this.isCallbackScheduled = true;
                } else if (addedOlderEvent) {
                    oldestEvent = this.sortedEvents.firstKey();
                    long callbackWait = oldestEvent - windowTailTime + 1L;
                    this.statementContext.getSchedulingService().remove(this.handle, this.scheduleSlot);
                    this.statementContext.getSchedulingService().add(callbackWait, (ScheduleHandle)this.handle, this.scheduleSlot);
                    this.isCallbackScheduled = true;
                }
            }
            if (postOldEvents != null) {
                postOldEventsArray = postOldEvents.toArray(new EventBean[postOldEvents.size()]);
            }
            if (this.optionalSortedRandomAccess != null) {
                this.optionalSortedRandomAccess.refresh(this.sortedEvents, this.eventCount);
            }
        }
        if (oldData != null && this.reverseIndex != null) {
            for (EventBean old : oldData) {
                ArrayList<EventBean> list = this.reverseIndex.remove(old);
                if (list == null) continue;
                list.remove(old);
            }
            if (postOldEventsArray == null) {
                postOldEventsArray = oldData;
            } else {
                HashSet<EventBean> oldDataSet = new HashSet<EventBean>();
                oldDataSet.addAll(Arrays.asList(postOldEventsArray));
                oldDataSet.addAll(Arrays.asList(oldData));
                postOldEventsArray = oldDataSet.toArray(new EventBean[oldDataSet.size()]);
            }
        }
        if (this.hasViews()) {
            this.updateChildren(newData, postOldEventsArray);
        }
    }

    public boolean isEmpty() {
        return this.sortedEvents.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new TimeOrderViewIterator(this.sortedEvents);
    }

    public final String toString() {
        return this.getClass().getName() + " timestampExpression=" + this.timestampExpression + " intervalSize=" + this.intervalSize;
    }

    /*
     * Unable to fully structure code
     */
    protected final void expire() {
        expireBeforeTimestamp = this.statementContext.getSchedulingService().getTime() - this.intervalSize + 1L;
        this.isCallbackScheduled = false;
        if (ExecutionPathDebugLog.isDebugEnabled && TimeOrderView.log.isDebugEnabled()) {
            TimeOrderView.log.debug(".expire Expiring messages before msec=" + expireBeforeTimestamp + "  date=" + this.statementContext.getSchedulingService().getTime());
        }
        releaseEvents = null;
        block0: while (true) {
            if (this.sortedEvents.isEmpty()) {
                oldestKey = null;
                break;
            }
            oldestKey = this.sortedEvents.firstKey();
            if (oldestKey >= expireBeforeTimestamp) break;
            expireEvents = this.sortedEvents.get(oldestKey);
            if (releaseEvents == null) {
                releaseEvents = expireEvents;
            } else {
                releaseEvents.addAll(expireEvents);
            }
            this.eventCount -= expireEvents.size();
            this.sortedEvents.remove(oldestKey);
            if (this.reverseIndex == null) continue;
            i$ = releaseEvents.iterator();
            while (true) {
                if (i$.hasNext()) ** break;
                continue block0;
                released = i$.next();
                this.reverseIndex.remove(released);
            }
            break;
        }
        if (this.optionalSortedRandomAccess != null) {
            this.optionalSortedRandomAccess.refresh(this.sortedEvents, this.eventCount);
        }
        if (this.hasViews() && releaseEvents != null && !releaseEvents.isEmpty()) {
            oldEvents = releaseEvents.toArray(new EventBean[releaseEvents.size()]);
            this.updateChildren(null, oldEvents);
        }
        if (ExecutionPathDebugLog.isDebugEnabled && TimeOrderView.log.isDebugEnabled()) {
            TimeOrderView.log.debug(".expire Expired messages....size=" + releaseEvents.size());
            for (EventBean object : releaseEvents) {
                TimeOrderView.log.debug(".expire object=" + object);
            }
        }
        if (oldestKey == null) {
            return;
        }
        callbackWait = oldestKey - expireBeforeTimestamp + 1L;
        this.statementContext.getSchedulingService().add(callbackWait, (ScheduleHandle)this.handle, this.scheduleSlot);
        this.isCallbackScheduled = true;
        if (ExecutionPathDebugLog.isDebugEnabled && TimeOrderView.log.isDebugEnabled()) {
            TimeOrderView.log.debug(".expire Scheduled new callback for now plus msec=" + callbackWait);
        }
    }
}

