/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.internal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.RollingEventBuffer;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.view.window.RelativeAccessByEventNIndex;
import java.util.HashMap;
import java.util.Map;

public class PriorEventBufferSingle
implements ViewUpdatedCollection,
RelativeAccessByEventNIndex {
    private final int priorEventIndex;
    private final Map<EventBean, EventBean> priorEventMap;
    private final RollingEventBuffer newEvents;
    private EventBean[] lastOldData;

    public PriorEventBufferSingle(int priorEventIndex) {
        this.priorEventIndex = priorEventIndex;
        this.newEvents = new RollingEventBuffer(priorEventIndex + 1);
        this.priorEventMap = new HashMap<EventBean, EventBean>();
    }

    public void update(EventBean[] newData, EventBean[] oldData) {
        int i;
        if (this.lastOldData != null) {
            for (i = 0; i < this.lastOldData.length; ++i) {
                this.priorEventMap.remove(this.lastOldData[i]);
            }
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                EventBean newEvent = newData[i];
                this.newEvents.add(newEvent);
                EventBean priorEvent = this.newEvents.get(this.priorEventIndex);
                this.priorEventMap.put(newEvent, priorEvent);
            }
        }
        this.lastOldData = oldData;
    }

    public EventBean getRelativeToEvent(EventBean event, int priorToIndex) {
        if (priorToIndex != 0) {
            throw new IllegalArgumentException("Single prior event buffer takes only a given index of zero");
        }
        EventBean priorEvent = this.priorEventMap.get(event);
        if (priorEvent == null && !this.priorEventMap.containsKey(event)) {
            throw new IllegalStateException("Event not currently in collection, event=" + event);
        }
        return priorEvent;
    }

    public void destroy() {
    }
}

