/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stat;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.ViewResourceCallback;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewCapability;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.stat.CorrelationView;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationViewFactory
implements ViewFactory {
    private List<ExprNode> viewParameters;
    protected ExprNode expressionX;
    protected ExprNode expressionY;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        ExprNode[] validated = ViewFactorySupport.validate("Correlation view", parentEventType, statementContext, this.viewParameters, false);
        String errorMessage = "Correlation view requires two expressions providing x and y values as properties";
        if (this.viewParameters.size() != 2) {
            throw new ViewParameterException(errorMessage);
        }
        if (!JavaClassHelper.isNumeric(validated[0].getType()) || !JavaClassHelper.isNumeric(validated[1].getType())) {
            throw new ViewParameterException(errorMessage);
        }
        this.expressionX = validated[0];
        this.expressionY = validated[1];
        this.eventType = CorrelationView.createEventType(statementContext);
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        return false;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
    }

    @Override
    public View makeView(StatementContext statementContext) {
        return new CorrelationView(statementContext, this.expressionX, this.expressionY);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof CorrelationView)) {
            return false;
        }
        CorrelationView other = (CorrelationView)view;
        return ExprNodeUtility.deepEquals(other.getExpressionX(), this.expressionX) && ExprNodeUtility.deepEquals(other.getExpressionY(), this.expressionY);
    }
}

