/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stat;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFieldEnum;
import com.espertech.esper.view.ViewSupport;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WeightedAverageView
extends ViewSupport
implements CloneableView {
    private final EventType eventType;
    private final StatementContext statementContext;
    private final ExprNode fieldNameX;
    private final ExprNode fieldNameWeight;
    private EventBean[] eventsPerStream = new EventBean[1];
    private double sumXtimesW = Double.NaN;
    private double sumW = Double.NaN;
    private double currentValue = Double.NaN;
    private EventBean lastNewEvent;

    public WeightedAverageView(StatementContext statementContext, ExprNode fieldNameX, ExprNode fieldNameWeight) {
        this.fieldNameX = fieldNameX;
        this.fieldNameWeight = fieldNameWeight;
        this.statementContext = statementContext;
        this.eventType = WeightedAverageView.createEventType(statementContext);
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return new WeightedAverageView(statementContext, this.fieldNameX, this.fieldNameWeight);
    }

    public final ExprNode getFieldNameX() {
        return this.fieldNameX;
    }

    public final ExprNode getFieldNameWeight() {
        return this.fieldNameWeight;
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        double weight;
        double point;
        int i;
        double oldValue = this.currentValue;
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                this.eventsPerStream[0] = newData[i];
                point = ((Number)this.fieldNameX.evaluate(this.eventsPerStream, true, this.statementContext)).doubleValue();
                weight = ((Number)this.fieldNameWeight.evaluate(this.eventsPerStream, true, this.statementContext)).doubleValue();
                if (Double.valueOf(this.sumXtimesW).isNaN()) {
                    this.sumXtimesW = point * weight;
                    this.sumW = weight;
                    continue;
                }
                this.sumXtimesW += point * weight;
                this.sumW += weight;
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                this.eventsPerStream[0] = oldData[i];
                point = ((Number)this.fieldNameX.evaluate(this.eventsPerStream, true, this.statementContext)).doubleValue();
                weight = ((Number)this.fieldNameWeight.evaluate(this.eventsPerStream, true, this.statementContext)).doubleValue();
                this.sumXtimesW -= point * weight;
                this.sumW -= weight;
            }
        }
        this.currentValue = this.sumW != 0.0 ? this.sumXtimesW / this.sumW : Double.NaN;
        if (this.hasViews()) {
            HashMap<String, Object> newDataMap = new HashMap<String, Object>();
            newDataMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), this.currentValue);
            EventBean newDataEvent = this.statementContext.getEventAdapterService().adaptorForTypedMap(newDataMap, this.eventType);
            if (this.lastNewEvent == null) {
                HashMap<String, Object> oldDataMap = new HashMap<String, Object>();
                oldDataMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), oldValue);
                EventBean oldDataEvent = this.statementContext.getEventAdapterService().adaptorForTypedMap(oldDataMap, this.eventType);
                this.updateChildren(new EventBean[]{newDataEvent}, new EventBean[]{oldDataEvent});
            } else {
                this.updateChildren(new EventBean[]{newDataEvent}, new EventBean[]{this.lastNewEvent});
            }
            this.lastNewEvent = newDataEvent;
        }
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        HashMap<String, Object> newDataMap = new HashMap<String, Object>();
        newDataMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), this.currentValue);
        return new SingleEventIterator(this.statementContext.getEventAdapterService().adaptorForTypedMap(newDataMap, this.eventType));
    }

    public final String toString() {
        return this.getClass().getName() + " fieldName=" + this.fieldNameX + " fieldNameWeight=" + this.fieldNameWeight;
    }

    protected static EventType createEventType(StatementContext statementContext) {
        HashMap<String, Object> schemaMap = new HashMap<String, Object>();
        schemaMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), Double.TYPE);
        return statementContext.getEventAdapterService().createAnonymousMapType(schemaMap);
    }
}

