/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FirstUniqueByPropertyView
extends ViewSupport
implements CloneableView {
    private final ExprNode[] uniqueCriteria;
    private final int numKeys;
    private EventBean[] eventsPerStream = new EventBean[1];
    private final Map<MultiKey<Object>, EventBean> firstEvents = new LinkedHashMap<MultiKey<Object>, EventBean>();
    private final ExprEvaluatorContext exprEvaluatorContext;
    private static final Log log = LogFactory.getLog(FirstUniqueByPropertyView.class);

    public FirstUniqueByPropertyView(ExprNode[] uniqueCriteria, ExprEvaluatorContext exprEvaluatorContext) {
        this.uniqueCriteria = uniqueCriteria;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.numKeys = uniqueCriteria.length;
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return new FirstUniqueByPropertyView(this.uniqueCriteria, this.exprEvaluatorContext);
    }

    public final ExprNode[] getUniqueCriteria() {
        return this.uniqueCriteria;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        MultiKey<Object> key;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Updating view");
            FirstUniqueByPropertyView.dumpUpdateParams("FirstUniqueByPropertyView", newData, oldData);
        }
        EventBean[] newDataToPost = null;
        EventBean[] oldDataToPost = null;
        if (newData != null) {
            for (EventBean newEvent : newData) {
                key = this.getUniqueKey(newEvent);
                if (this.firstEvents.containsKey(key)) continue;
                this.firstEvents.put(key, newEvent);
                newDataToPost = newDataToPost == null ? new EventBean[]{newEvent} : EventBeanUtility.addToArray(newDataToPost, newEvent);
            }
        }
        if (oldData != null) {
            for (EventBean oldEvent : oldData) {
                key = this.getUniqueKey(oldEvent);
                EventBean lastValue = this.firstEvents.get(key);
                if (lastValue != oldEvent) continue;
                oldDataToPost = oldDataToPost == null ? new EventBean[]{oldEvent} : EventBeanUtility.addToArray(oldDataToPost, oldEvent);
                this.firstEvents.remove(key);
            }
        }
        if (this.hasViews() && (newDataToPost != null || oldDataToPost != null)) {
            this.updateChildren(newDataToPost, oldDataToPost);
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.firstEvents.values().iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " uniqueCriteria=" + Arrays.toString(this.uniqueCriteria);
    }

    private MultiKey<Object> getUniqueKey(EventBean event) {
        Object[] values = new Object[this.numKeys];
        this.eventsPerStream[0] = event;
        for (int i = 0; i < this.numKeys; ++i) {
            values[i] = this.uniqueCriteria[i].evaluate(this.eventsPerStream, true, this.exprEvaluatorContext);
        }
        return new MultiKey<Object>(values);
    }

    public boolean isEmpty() {
        return this.firstEvents.isEmpty();
    }
}

