/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.IterablesListIterator;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.std.AddPropertyValueView;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MergeView
extends ViewSupport
implements CloneableView {
    private final LinkedList<View> parentViews = new LinkedList();
    private final ExprNode[] groupFieldNames;
    private final EventType eventType;
    private static final Log log = LogFactory.getLog(MergeView.class);

    public MergeView(StatementContext statementContext, ExprNode[] groupCriteria, EventType resultEventType) {
        this.groupFieldNames = groupCriteria;
        this.eventType = resultEventType;
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return new MergeView(statementContext, this.groupFieldNames, this.eventType);
    }

    public final ExprNode[] getGroupFieldNames() {
        return this.groupFieldNames;
    }

    public final void addParentView(AddPropertyValueView parentView) {
        this.parentViews.add(parentView);
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Updating view");
            MergeView.dumpUpdateParams("MergeView", newData, oldData);
        }
        this.updateChildren(newData, oldData);
    }

    @Override
    public final Iterator<EventBean> iterator() {
        LinkedList<Iterable<EventBean>> iterables = new LinkedList<Iterable<EventBean>>();
        for (View dataView : this.parentViews) {
            iterables.add(dataView);
        }
        return new IterablesListIterator(iterables);
    }

    public final String toString() {
        return this.getClass().getName() + " groupFieldName=" + Arrays.toString(this.groupFieldNames);
    }
}

