/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFieldEnum;
import com.espertech.esper.view.ViewSupport;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SizeView
extends ViewSupport
implements CloneableView {
    private final StatementContext statementContext;
    private EventType eventType;
    private long size = 0L;
    private EventBean lastSizeEvent;

    public SizeView(StatementContext statementContext) {
        this.statementContext = statementContext;
        this.eventType = SizeView.createEventType(statementContext);
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return new SizeView(statementContext);
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        long priorSize = this.size;
        if (newData != null) {
            this.size += (long)newData.length;
        }
        if (oldData != null) {
            this.size -= (long)oldData.length;
        }
        if (this.hasViews() && priorSize != this.size) {
            HashMap<String, Object> postNewData = new HashMap<String, Object>();
            postNewData.put(ViewFieldEnum.SIZE_VIEW__SIZE.getName(), this.size);
            EventBean newEvent = this.statementContext.getEventAdapterService().adaptorForTypedMap(postNewData, this.eventType);
            if (this.lastSizeEvent != null) {
                this.updateChildren(new EventBean[]{newEvent}, new EventBean[]{this.lastSizeEvent});
            } else {
                HashMap<String, Object> postOldData = new HashMap<String, Object>();
                postOldData.put(ViewFieldEnum.SIZE_VIEW__SIZE.getName(), priorSize);
                EventBean oldEvent = this.statementContext.getEventAdapterService().adaptorForTypedMap(postOldData, this.eventType);
                this.updateChildren(new EventBean[]{newEvent}, new EventBean[]{oldEvent});
            }
            this.lastSizeEvent = newEvent;
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        HashMap<String, Object> current = new HashMap<String, Object>();
        current.put(ViewFieldEnum.SIZE_VIEW__SIZE.getName(), this.size);
        return new SingleEventIterator(this.statementContext.getEventAdapterService().adaptorForTypedMap(current, this.eventType));
    }

    public final String toString() {
        return this.getClass().getName();
    }

    protected static EventType createEventType(StatementContext statementContext) {
        HashMap<String, Object> schemaMap = new HashMap<String, Object>();
        schemaMap.put(ViewFieldEnum.SIZE_VIEW__SIZE.getName(), Long.TYPE);
        return statementContext.getEventAdapterService().createAnonymousMapType(schemaMap);
    }
}

