/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stream;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.collection.RefCountedMap;
import com.espertech.esper.core.EPStatementHandle;
import com.espertech.esper.core.EPStatementHandleCallback;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.filter.FilterHandleCallback;
import com.espertech.esper.filter.FilterService;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterValueSet;
import com.espertech.esper.util.ManagedLock;
import com.espertech.esper.view.EventStream;
import com.espertech.esper.view.ZeroDepthStream;
import com.espertech.esper.view.stream.StreamFactoryService;
import java.util.IdentityHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamFactorySvcImpl
implements StreamFactoryService {
    private static Log log = LogFactory.getLog(StreamFactorySvcImpl.class);
    private final IdentityHashMap<FilterSpecCompiled, Pair<EventStream, EPStatementHandleCallback>> eventStreamsIdentity;
    private final RefCountedMap<FilterSpecCompiled, Pair<EventStream, EPStatementHandleCallback>> eventStreamsRefCounted = new RefCountedMap();
    private boolean isReuseViews;

    public StreamFactorySvcImpl(boolean isReuseViews) {
        this.eventStreamsIdentity = new IdentityHashMap();
        this.isReuseViews = isReuseViews;
    }

    @Override
    public void destroy() {
        this.eventStreamsRefCounted.clear();
        this.eventStreamsIdentity.clear();
    }

    @Override
    public Pair<EventStream, ManagedLock> createStream(final String statementId, final FilterSpecCompiled filterSpec, FilterService filterService, EPStatementHandle epStatementHandle, boolean isJoin, final boolean isSubSelect, final ExprEvaluatorContext exprEvaluatorContext, boolean isNamedWindowTrigger) {
        boolean forceNewStream;
        Pair<EventStream, EPStatementHandleCallback> pair;
        if (log.isDebugEnabled()) {
            log.debug(".createStream hashCode=" + filterSpec.hashCode() + " filter=" + filterSpec);
        }
        if ((pair = (forceNewStream = isJoin || !this.isReuseViews || isSubSelect || isNamedWindowTrigger) ? this.eventStreamsIdentity.get(filterSpec) : this.eventStreamsRefCounted.get(filterSpec)) != null) {
            if (forceNewStream) {
                throw new IllegalStateException("Filter spec object already found in collection");
            }
            log.debug(".createStream filter already found");
            this.eventStreamsRefCounted.reference(filterSpec);
            return new Pair<EventStream, ManagedLock>(pair.getFirst(), pair.getSecond().getEpStatementHandle().getStatementLock());
        }
        EventType resultEventType = filterSpec.getResultEventType();
        final ZeroDepthStream eventStream = new ZeroDepthStream(resultEventType);
        FilterHandleCallback filterCallback = filterSpec.getOptionalPropertyEvaluator() != null ? new FilterHandleCallback(){

            public String getStatementId() {
                return statementId;
            }

            public void matchFound(EventBean event) {
                EventBean[] result = filterSpec.getOptionalPropertyEvaluator().getProperty(event, exprEvaluatorContext);
                if (result == null) {
                    return;
                }
                eventStream.insert(result);
            }

            public boolean isSubSelect() {
                return isSubSelect;
            }
        } : new FilterHandleCallback(){

            public String getStatementId() {
                return statementId;
            }

            public void matchFound(EventBean event) {
                eventStream.insert(event);
            }

            public boolean isSubSelect() {
                return isSubSelect;
            }
        };
        EPStatementHandleCallback handle = new EPStatementHandleCallback(epStatementHandle, filterCallback);
        pair = new Pair<ZeroDepthStream, EPStatementHandleCallback>(eventStream, handle);
        if (forceNewStream) {
            this.eventStreamsIdentity.put(filterSpec, pair);
        } else {
            this.eventStreamsRefCounted.put(filterSpec, pair);
        }
        FilterValueSet filterValues = filterSpec.getValueSet(null);
        filterService.add(filterValues, handle);
        return new Pair<ZeroDepthStream, Object>(eventStream, null);
    }

    @Override
    public void dropStream(FilterSpecCompiled filterSpec, FilterService filterService, boolean isJoin, boolean isSubSelect, boolean isNamedWindowTrigger) {
        boolean forceNewStream;
        boolean bl = forceNewStream = isJoin || !this.isReuseViews || isSubSelect || isNamedWindowTrigger;
        if (forceNewStream) {
            Pair<EventStream, EPStatementHandleCallback> pair = this.eventStreamsIdentity.get(filterSpec);
            if (pair == null) {
                throw new IllegalStateException("Filter spec object not in collection");
            }
            this.eventStreamsIdentity.remove(filterSpec);
            filterService.remove(pair.getSecond());
        } else {
            Pair<EventStream, EPStatementHandleCallback> pair = this.eventStreamsRefCounted.get(filterSpec);
            boolean isLast = this.eventStreamsRefCounted.dereference(filterSpec);
            if (isLast) {
                filterService.remove(pair.getSecond());
            }
        }
    }
}

