/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayDequeJDK6Backport;
import com.espertech.esper.collection.TimeWindow;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.ExternallyTimedWindowViewFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExternallyTimedWindowView
extends ViewSupport
implements DataWindowView,
CloneableView {
    private final ExternallyTimedWindowViewFactory externallyTimedWindowViewFactory;
    private final ExprNode timestampExpression;
    private final long millisecondsBeforeExpiry;
    private final EventBean[] eventsPerStream = new EventBean[1];
    private final TimeWindow timeWindow;
    private ViewUpdatedCollection viewUpdatedCollection;
    private boolean isRemoveStreamHandling;
    private ExprEvaluatorContext exprEvaluatorContext;

    public ExternallyTimedWindowView(ExternallyTimedWindowViewFactory externallyTimedWindowViewFactory, ExprNode timestampExpression, long msecBeforeExpiry, ViewUpdatedCollection viewUpdatedCollection, boolean isRemoveStreamHandling, ExprEvaluatorContext exprEvaluatorContext) {
        this.externallyTimedWindowViewFactory = externallyTimedWindowViewFactory;
        this.timestampExpression = timestampExpression;
        this.millisecondsBeforeExpiry = msecBeforeExpiry;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.isRemoveStreamHandling = isRemoveStreamHandling;
        this.timeWindow = new TimeWindow(isRemoveStreamHandling);
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return this.externallyTimedWindowViewFactory.makeView(statementContext);
    }

    public final ExprNode getTimestampExpression() {
        return this.timestampExpression;
    }

    public final long getMillisecondsBeforeExpiry() {
        return this.millisecondsBeforeExpiry;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        long timestamp2 = -1L;
        if (newData != null) {
            for (int i = 0; i < newData.length; ++i) {
                timestamp2 = this.getLongValue(newData[i]);
                this.timeWindow.add(timestamp2, newData[i]);
            }
        }
        ArrayDequeJDK6Backport<EventBean> expired = null;
        if (timestamp2 != -1L) {
            expired = this.timeWindow.expireEvents(timestamp2 - this.millisecondsBeforeExpiry + 1L);
        }
        EventBean[] oldDataUpdate = null;
        if (expired != null && !expired.isEmpty()) {
            oldDataUpdate = expired.toArray(new EventBean[expired.size()]);
        }
        if (oldData != null && this.isRemoveStreamHandling) {
            for (EventBean anOldData : oldData) {
                this.timeWindow.remove(anOldData);
            }
            if (oldDataUpdate == null) {
                oldDataUpdate = oldData;
            } else {
                HashSet<EventBean> oldDataPost = new HashSet<EventBean>();
                oldDataPost.addAll(Arrays.asList(oldData));
                oldDataPost.addAll(Arrays.asList(oldDataUpdate));
                oldDataUpdate = oldDataPost.toArray(new EventBean[oldDataPost.size()]);
            }
        }
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, oldDataUpdate);
        }
        if (this.hasViews()) {
            this.updateChildren(newData, oldDataUpdate);
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.timeWindow.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " timestampExpression=" + this.timestampExpression + " millisecondsBeforeExpiry=" + this.millisecondsBeforeExpiry;
    }

    private long getLongValue(EventBean obj) {
        this.eventsPerStream[0] = obj;
        Number num = (Number)this.timestampExpression.evaluate(this.eventsPerStream, true, this.exprEvaluatorContext);
        return num.longValue();
    }

    public boolean isEmpty() {
        return this.timeWindow.isEmpty();
    }
}

