/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.ViewResourceCallback;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.named.RemoveStreamViewCapability;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewCapDataWindowAccess;
import com.espertech.esper.view.ViewCapability;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.window.ExternallyTimedWindowView;
import com.espertech.esper.view.window.IStreamRandomAccess;
import com.espertech.esper.view.window.RandomAccessByIndexGetter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternallyTimedWindowViewFactory
implements DataWindowViewFactory {
    private List<ExprNode> viewParameters;
    private EventType eventType;
    protected ExprNode timestampExpression;
    protected long millisecondsBeforeExpiry;
    protected boolean isRemoveStreamHandling;
    protected RandomAccessByIndexGetter randomAccessGetterImpl;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        ExprNode[] validated = ViewFactorySupport.validate("Externally-timed window", parentEventType, statementContext, this.viewParameters, true);
        String errorMessage = "Externally-timed window view requires a timestamp expression and a numeric or time period parameter for window size";
        if (this.viewParameters.size() != 2) {
            throw new ViewParameterException(errorMessage);
        }
        if (!JavaClassHelper.isNumeric(validated[0].getType())) {
            throw new ViewParameterException(errorMessage);
        }
        this.timestampExpression = validated[0];
        ViewFactorySupport.assertReturnsNonConstant("Externally-timed window", validated[0], 0);
        Object parameter = ViewFactorySupport.evaluateAssertNoProperties("Externally-timed window", validated[1], 1, statementContext);
        if (!(parameter instanceof Number)) {
            throw new ViewParameterException(errorMessage);
        }
        Number param = (Number)parameter;
        this.millisecondsBeforeExpiry = JavaClassHelper.isFloatingPointNumber(param) ? Math.round(1000.0 * param.doubleValue()) : 1000L * param.longValue();
        this.eventType = parentEventType;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        if (viewCapability instanceof ViewCapDataWindowAccess) {
            return true;
        }
        return viewCapability instanceof RemoveStreamViewCapability;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        if (!this.canProvideCapability(viewCapability)) {
            throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
        }
        if (viewCapability instanceof RemoveStreamViewCapability) {
            this.isRemoveStreamHandling = true;
            return;
        }
        if (this.randomAccessGetterImpl == null) {
            this.randomAccessGetterImpl = new RandomAccessByIndexGetter();
        }
        resourceCallback.setViewResource(this.randomAccessGetterImpl);
    }

    @Override
    public View makeView(StatementContext statementContext) {
        IStreamRandomAccess randomAccess = null;
        if (this.randomAccessGetterImpl != null) {
            randomAccess = new IStreamRandomAccess(this.randomAccessGetterImpl);
            this.randomAccessGetterImpl.updated(randomAccess);
        }
        return new ExternallyTimedWindowView(this, this.timestampExpression, this.millisecondsBeforeExpiry, randomAccess, this.isRemoveStreamHandling, statementContext);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (this.randomAccessGetterImpl != null) {
            return false;
        }
        if (!(view instanceof ExternallyTimedWindowView)) {
            return false;
        }
        ExternallyTimedWindowView myView = (ExternallyTimedWindowView)view;
        if (myView.getMillisecondsBeforeExpiry() != this.millisecondsBeforeExpiry || !ExprNodeUtility.deepEquals(myView.getTimestampExpression(), this.timestampExpression)) {
            return false;
        }
        return myView.isEmpty();
    }
}

