/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.OneEventCollection;
import com.espertech.esper.core.EPStatementHandleCallback;
import com.espertech.esper.core.ExtensionServicesContext;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.BatchingDataWindowView;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.FirstTimeViewFactory;
import com.espertech.esper.view.window.TimeBatchViewRStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FirstTimeView
extends ViewSupport
implements CloneableView,
BatchingDataWindowView {
    private final FirstTimeViewFactory timeFirstViewFactory;
    private final StatementContext statementContext;
    private final long msecIntervalSize;
    private final ScheduleSlot scheduleSlot;
    private LinkedHashSet<EventBean> events = new LinkedHashSet();
    private boolean isClosed;
    private static final Log log = LogFactory.getLog(TimeBatchViewRStream.class);

    public FirstTimeView(FirstTimeViewFactory timeFirstViewFactory, StatementContext statementContext, long msecIntervalSize) {
        this.statementContext = statementContext;
        this.timeFirstViewFactory = timeFirstViewFactory;
        this.msecIntervalSize = msecIntervalSize;
        this.scheduleSlot = statementContext.getScheduleBucket().allocateSlot();
        this.scheduleCallback();
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return this.timeFirstViewFactory.makeView(statementContext);
    }

    public final long getMsecIntervalSize() {
        return this.msecIntervalSize;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        if (this.statementContext == null) {
            String message = "View context has not been supplied, cannot schedule callback";
            log.fatal(".update " + message);
            throw new EPException(message);
        }
        OneEventCollection oldDataToPost = null;
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                boolean removed = this.events.remove(anOldData);
                if (!removed) continue;
                if (oldDataToPost == null) {
                    oldDataToPost = new OneEventCollection();
                }
                oldDataToPost.add(anOldData);
            }
        }
        OneEventCollection newDataToPost = null;
        if (!this.isClosed && newData != null) {
            for (EventBean aNewData : newData) {
                this.events.add(aNewData);
                if (newDataToPost == null) {
                    newDataToPost = new OneEventCollection();
                }
                newDataToPost.add(aNewData);
            }
        }
        if (this.hasViews() && (newDataToPost != null || oldDataToPost != null)) {
            this.updateChildren(newDataToPost != null ? newDataToPost.toArray() : null, oldDataToPost != null ? oldDataToPost.toArray() : null);
        }
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.events.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " msecIntervalSize=" + this.msecIntervalSize;
    }

    private void scheduleCallback() {
        long afterMSec = this.msecIntervalSize;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".scheduleCallback Scheduled new callback for  afterMsec=" + afterMSec + " msecIntervalSize=" + this.msecIntervalSize);
        }
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                FirstTimeView.this.isClosed = true;
            }
        };
        EPStatementHandleCallback handle = new EPStatementHandleCallback(this.statementContext.getEpStatementHandle(), callback);
        this.statementContext.getSchedulingService().add(afterMSec, (ScheduleHandle)handle, this.scheduleSlot);
    }
}

