/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.view.window.RelativeAccessByEventNIndex;
import java.util.HashMap;
import java.util.Map;

public class IStreamRelativeAccess
implements RelativeAccessByEventNIndex,
ViewUpdatedCollection {
    private final Map<EventBean, Integer> indexPerEvent;
    private EventBean[] lastNewData;
    private final IStreamRelativeAccessUpdateObserver updateObserver;

    public IStreamRelativeAccess(IStreamRelativeAccessUpdateObserver updateObserver) {
        this.updateObserver = updateObserver;
        this.indexPerEvent = new HashMap<EventBean, Integer>();
    }

    public void update(EventBean[] newData, EventBean[] oldData) {
        this.updateObserver.updated(this, newData);
        this.indexPerEvent.clear();
        this.lastNewData = newData;
        if (newData != null) {
            for (int i = 0; i < newData.length; ++i) {
                this.indexPerEvent.put(newData[i], i);
            }
        }
    }

    public EventBean getRelativeToEvent(EventBean event, int prevIndex) {
        if (this.lastNewData == null) {
            return null;
        }
        if (prevIndex == 0) {
            return event;
        }
        Integer indexIncoming = this.indexPerEvent.get(event);
        if (indexIncoming == null) {
            return null;
        }
        if (prevIndex > indexIncoming) {
            return null;
        }
        int relativeIndex = indexIncoming - prevIndex;
        if (relativeIndex < this.lastNewData.length && relativeIndex >= 0) {
            return this.lastNewData[relativeIndex];
        }
        return null;
    }

    public void destroy() {
    }

    public static interface IStreamRelativeAccessUpdateObserver {
        public void updated(IStreamRelativeAccess var1, EventBean[] var2);
    }
}

