/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.KeepAllViewFactory;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeepAllView
extends ViewSupport
implements DataWindowView,
CloneableView {
    private final KeepAllViewFactory keepAllViewFactory;
    private LinkedHashSet<EventBean> indexedEvents;
    private final ViewUpdatedCollection viewUpdatedCollection;

    public KeepAllView(KeepAllViewFactory keepAllViewFactory, ViewUpdatedCollection viewUpdatedCollection) {
        this.keepAllViewFactory = keepAllViewFactory;
        this.indexedEvents = new LinkedHashSet();
        this.viewUpdatedCollection = viewUpdatedCollection;
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return this.keepAllViewFactory.makeView(statementContext);
    }

    public boolean isEmpty() {
        return this.indexedEvents.isEmpty();
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null) {
            this.indexedEvents.addAll(Arrays.asList(newData));
        }
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                this.indexedEvents.remove(anOldData);
            }
        }
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, oldData);
        }
        this.updateChildren(newData, oldData);
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.indexedEvents.iterator();
    }
}

