/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.EPStatementHandleCallback;
import com.espertech.esper.core.ExtensionServicesContext;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.BatchingDataWindowView;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.TimeLengthBatchViewFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeLengthBatchView
extends ViewSupport
implements CloneableView,
BatchingDataWindowView {
    private static final Log log = LogFactory.getLog(TimeLengthBatchView.class);
    private final TimeLengthBatchViewFactory timeLengthBatchViewFactory;
    private final StatementContext statementContext;
    private final long msecIntervalSize;
    private final long numberOfEvents;
    private final boolean isForceOutput;
    private final boolean isStartEager;
    private final ViewUpdatedCollection viewUpdatedCollection;
    private final ScheduleSlot scheduleSlot;
    private ArrayList<EventBean> lastBatch = null;
    private ArrayList<EventBean> currentBatch = new ArrayList();
    private boolean isCallbackScheduled;
    private EPStatementHandleCallback handle;

    public TimeLengthBatchView(TimeLengthBatchViewFactory timeBatchViewFactory, StatementContext statementContext, long msecIntervalSize, long numberOfEvents, boolean forceOutput, boolean isStartEager, ViewUpdatedCollection viewUpdatedCollection) {
        this.statementContext = statementContext;
        this.timeLengthBatchViewFactory = timeBatchViewFactory;
        this.msecIntervalSize = msecIntervalSize;
        this.numberOfEvents = numberOfEvents;
        this.isStartEager = isStartEager;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.isForceOutput = forceOutput;
        this.scheduleSlot = statementContext.getScheduleBucket().allocateSlot();
        if (isStartEager) {
            this.scheduleCallback();
            this.isCallbackScheduled = true;
        }
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return this.timeLengthBatchViewFactory.makeView(statementContext);
    }

    public final long getMsecIntervalSize() {
        return this.msecIntervalSize;
    }

    public boolean isForceOutput() {
        return this.isForceOutput;
    }

    public long getNumberOfEvents() {
        return this.numberOfEvents;
    }

    public boolean isStartEager() {
        return this.isStartEager;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        if (oldData != null) {
            for (int i = 0; i < oldData.length; ++i) {
                this.currentBatch.remove(oldData[i]);
            }
        }
        if (newData == null || newData.length == 0) {
            return;
        }
        this.currentBatch.addAll(Arrays.asList(newData));
        if ((long)this.currentBatch.size() < this.numberOfEvents) {
            if (!this.isCallbackScheduled) {
                this.scheduleCallback();
                this.isCallbackScheduled = true;
            }
            return;
        }
        this.sendBatch(false);
    }

    protected final void sendBatch(boolean isFromSchedule) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendBatch Update child views,   time=" + this.statementContext.getSchedulingService().getTime());
        }
        if (isFromSchedule) {
            this.isCallbackScheduled = false;
        } else if (this.isCallbackScheduled) {
            this.statementContext.getSchedulingService().remove(this.handle, this.scheduleSlot);
            this.isCallbackScheduled = false;
        }
        if (this.hasViews()) {
            EventBean[] newData = null;
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                newData = this.currentBatch.toArray(new EventBean[this.currentBatch.size()]);
            }
            if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
                oldData = this.lastBatch.toArray(new EventBean[this.lastBatch.size()]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(newData, oldData);
            }
            if (newData != null || oldData != null || this.isForceOutput) {
                this.updateChildren(newData, oldData);
            }
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendBatch Published updated data, ....newData size=" + this.currentBatch.size());
            for (EventBean object : this.currentBatch) {
                log.debug(".sendBatch object=" + object);
            }
        }
        if (!this.currentBatch.isEmpty() || this.lastBatch != null && !this.lastBatch.isEmpty() || this.isForceOutput) {
            this.scheduleCallback();
            this.isCallbackScheduled = true;
        }
        this.lastBatch = this.currentBatch;
        this.currentBatch = new ArrayList();
    }

    public boolean isEmpty() {
        if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
            return false;
        }
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " msecIntervalSize=" + this.msecIntervalSize + " numberOfEvents=" + this.numberOfEvents;
    }

    private void scheduleCallback() {
        long current = this.statementContext.getSchedulingService().getTime();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".scheduleCallback Scheduled new callback for  msecIntervalSize=" + this.msecIntervalSize + " now=" + current);
        }
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                TimeLengthBatchView.this.sendBatch(true);
            }
        };
        this.handle = new EPStatementHandleCallback(this.statementContext.getEpStatementHandle(), callback);
        this.statementContext.getSchedulingService().add(this.msecIntervalSize, (ScheduleHandle)this.handle, this.scheduleSlot);
    }
}

