/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.ViewResourceCallback;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.named.RemoveStreamViewCapability;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewCapDataWindowAccess;
import com.espertech.esper.view.ViewCapability;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.window.IStreamRelativeAccess;
import com.espertech.esper.view.window.RelativeAccessByEventNIndexMap;
import com.espertech.esper.view.window.TimeBatchViewFactoryParams;
import com.espertech.esper.view.window.TimeLengthBatchView;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLengthBatchViewFactory
extends TimeBatchViewFactoryParams
implements DataWindowViewFactory {
    protected long numberOfEvents;
    protected RelativeAccessByEventNIndexMap relativeAccessGetterImpl;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        List<Object> viewParameters = ViewFactorySupport.validateAndEvaluate("Time-length combination batch view", viewFactoryContext.getStatementContext(), expressionParameters);
        String errorMessage = "Time-length combination batch view requires a numeric or time period parameter as a time interval size, and an integer parameter as a maximal number-of-events, and an optional list of control keywords as a string parameter (please see the documentation)";
        if (viewParameters.size() != 2 && viewParameters.size() != 3) {
            throw new ViewParameterException(errorMessage);
        }
        this.processExpiry(viewParameters.get(0), errorMessage, "Time-length-combination batch view requires a size of at least 1 msec");
        Object parameter = viewParameters.get(1);
        if (!(parameter instanceof Number) || JavaClassHelper.isFloatingPointNumber((Number)parameter)) {
            throw new ViewParameterException(errorMessage);
        }
        this.numberOfEvents = ((Number)parameter).longValue();
        if (viewParameters.size() > 2) {
            this.processKeywords(viewParameters.get(2), errorMessage);
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        if (viewCapability instanceof RemoveStreamViewCapability) {
            return true;
        }
        return viewCapability instanceof ViewCapDataWindowAccess;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        if (!this.canProvideCapability(viewCapability)) {
            throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
        }
        if (viewCapability instanceof RemoveStreamViewCapability) {
            return;
        }
        if (this.relativeAccessGetterImpl == null) {
            this.relativeAccessGetterImpl = new RelativeAccessByEventNIndexMap();
        }
        resourceCallback.setViewResource(this.relativeAccessGetterImpl);
    }

    @Override
    public View makeView(StatementContext statementContext) {
        IStreamRelativeAccess relativeAccessByEvent = null;
        if (this.relativeAccessGetterImpl != null) {
            relativeAccessByEvent = new IStreamRelativeAccess(this.relativeAccessGetterImpl);
            this.relativeAccessGetterImpl.updated(relativeAccessByEvent, null);
        }
        return new TimeLengthBatchView(this, statementContext, this.millisecondsBeforeExpiry, this.numberOfEvents, this.isForceUpdate, this.isStartEager, relativeAccessByEvent);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (this.relativeAccessGetterImpl != null) {
            return false;
        }
        if (!(view instanceof TimeLengthBatchView)) {
            return false;
        }
        TimeLengthBatchView myView = (TimeLengthBatchView)view;
        if (myView.getMsecIntervalSize() != this.millisecondsBeforeExpiry) {
            return false;
        }
        if (myView.getNumberOfEvents() != this.numberOfEvents) {
            return false;
        }
        if (myView.isForceOutput() != this.isForceUpdate) {
            return false;
        }
        if (myView.isStartEager()) {
            return false;
        }
        return myView.isEmpty();
    }
}

