/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.RemoteDocument;
import com.github.jsonldjava.utils.JarCacheStorage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClient;

public class DocumentLoader {
    public static final String ACCEPT_HEADER = "application/ld+json, application/json;q=0.9, application/javascript;q=0.5, text/javascript;q=0.5, text/plain;q=0.2, */*;q=0.1";
    protected static volatile CachingHttpClient defaultHttpClient;
    private volatile HttpClient httpClient;

    public RemoteDocument loadDocument(String url) throws JsonLdError {
        RemoteDocument doc = new RemoteDocument(url, null);
        try {
            doc.setDocument(this.fromURL(new URL(url)));
        }
        catch (Exception e2) {
            new JsonLdError(JsonLdError.Error.LOADING_REMOTE_CONTEXT_FAILED, url);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fromURL(URL url) throws JsonParseException, IOException {
        MappingJsonFactory jsonFactory = new MappingJsonFactory();
        InputStream in = this.openStreamFromURL(url);
        try {
            Map map;
            JsonParser parser = jsonFactory.createParser(in);
            try {
                JsonToken token = parser.nextToken();
                Class type = token == JsonToken.START_OBJECT ? Map.class : (token == JsonToken.START_ARRAY ? List.class : String.class);
                map = parser.readValueAs(type);
            }
            catch (Throwable throwable) {
                parser.close();
                throw throwable;
            }
            parser.close();
            return map;
        }
        finally {
            in.close();
        }
    }

    public InputStream openStreamFromURL(URL url) throws IOException {
        String protocol = url.getProtocol();
        if (!protocol.equalsIgnoreCase("http") && !protocol.equalsIgnoreCase("https")) {
            return url.openStream();
        }
        HttpGet request = new HttpGet(url.toExternalForm());
        request.addHeader("Accept", ACCEPT_HEADER);
        HttpResponse response = this.getHttpClient().execute(request);
        int status = response.getStatusLine().getStatusCode();
        if (status != 200 && status != 203) {
            throw new IOException("Can't retrieve " + url + ", status code: " + status);
        }
        return response.getEntity().getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static HttpClient getDefaultHttpClient() {
        CachingHttpClient result = defaultHttpClient;
        if (result != null) {
            return result;
        }
        Class<DocumentLoader> clazz = DocumentLoader.class;
        synchronized (DocumentLoader.class) {
            if (defaultHttpClient == null) {
                SystemDefaultHttpClient client = new SystemDefaultHttpClient();
                client.addRequestInterceptor(new RequestAcceptEncoding());
                client.addResponseInterceptor(new ResponseContentEncoding());
                CacheConfig cacheConfig = new CacheConfig();
                cacheConfig.setMaxObjectSize(131072L);
                cacheConfig.setMaxCacheEntries(1000);
                CachingHttpClient cachingClient = new CachingHttpClient(client, cacheConfig);
                JarCacheStorage jarCache = new JarCacheStorage();
                defaultHttpClient = new CachingHttpClient((HttpClient)cachingClient, jarCache, jarCache.getCacheConfig());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultHttpClient;
        }
    }

    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            return DocumentLoader.getDefaultHttpClient();
        }
        return this.httpClient;
    }

    public void setHttpClient(HttpClient nextHttpClient) {
        this.httpClient = nextHttpClient;
    }
}

