/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public final class JsonParser {
    public JsonElement parse(String json2) throws JsonSyntaxException {
        return this.parse(new StringReader(json2));
    }

    public JsonElement parse(Reader json2) throws JsonIOException, JsonSyntaxException {
        try {
            JsonReader jsonReader = new JsonReader(json2);
            JsonElement element = this.parse(jsonReader);
            if (!element.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return element;
        }
        catch (MalformedJsonException e2) {
            throw new JsonSyntaxException(e2);
        }
        catch (IOException e3) {
            throw new JsonIOException(e3);
        }
        catch (NumberFormatException e4) {
            throw new JsonSyntaxException(e4);
        }
    }

    public JsonElement parse(JsonReader json2) throws JsonIOException, JsonSyntaxException {
        boolean lenient = json2.isLenient();
        json2.setLenient(true);
        try {
            JsonElement jsonElement = Streams.parse(json2);
            return jsonElement;
        }
        catch (StackOverflowError e2) {
            throw new JsonParseException("Failed parsing JSON source: " + json2 + " to Json", e2);
        }
        catch (OutOfMemoryError e3) {
            throw new JsonParseException("Failed parsing JSON source: " + json2 + " to Json", e3);
        }
        finally {
            json2.setLenient(lenient);
        }
    }
}

