/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphStatisticsHandler;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.shared.AddDeniedException;
import com.hp.hpl.jena.shared.DeleteDeniedException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;

public interface Graph {
    public static final Graph emptyGraph = new GraphBase(){

        @Override
        public ExtendedIterator<Triple> graphBaseFind(Triple tm) {
            return NullIterator.instance();
        }
    };

    public boolean dependsOn(Graph var1);

    public TransactionHandler getTransactionHandler();

    @Deprecated
    public BulkUpdateHandler getBulkUpdateHandler();

    public Capabilities getCapabilities();

    public GraphEventManager getEventManager();

    public GraphStatisticsHandler getStatisticsHandler();

    public PrefixMapping getPrefixMapping();

    public void add(Triple var1) throws AddDeniedException;

    public void delete(Triple var1) throws DeleteDeniedException;

    @Deprecated
    public ExtendedIterator<Triple> find(TripleMatch var1);

    public ExtendedIterator<Triple> find(Triple var1);

    public ExtendedIterator<Triple> find(Node var1, Node var2, Node var3);

    public boolean isIsomorphicWith(Graph var1);

    public boolean contains(Node var1, Node var2, Node var3);

    public boolean contains(Triple var1);

    public void clear();

    public void remove(Node var1, Node var2, Node var3);

    public void close();

    public boolean isEmpty();

    public int size();

    public boolean isClosed();
}

