/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.TrackingTripleIterator;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SimpleEventManager
implements GraphEventManager {
    @Deprecated
    protected Graph graph = null;
    protected List<GraphListener> listeners = new CopyOnWriteArrayList<GraphListener>();

    @Deprecated
    public SimpleEventManager(Graph graph) {
        this();
        this.graph = graph;
    }

    public SimpleEventManager() {
    }

    @Override
    public GraphEventManager register(GraphListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public GraphEventManager unregister(GraphListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    @Override
    public boolean listening() {
        return this.listeners.size() > 0;
    }

    @Override
    public void notifyAddTriple(Graph g, Triple t) {
        for (GraphListener l : this.listeners) {
            l.notifyAddTriple(g, t);
        }
    }

    @Override
    public void notifyAddArray(Graph g, Triple[] ts) {
        for (GraphListener l : this.listeners) {
            l.notifyAddArray(g, ts);
        }
    }

    @Override
    public void notifyAddList(Graph g, List<Triple> L) {
        for (GraphListener l : this.listeners) {
            l.notifyAddList(g, L);
        }
    }

    @Override
    public void notifyAddIterator(Graph g, List<Triple> it) {
        for (GraphListener l : this.listeners) {
            l.notifyAddIterator(g, it.iterator());
        }
    }

    @Override
    public void notifyAddIterator(Graph g, Iterator<Triple> it) {
        this.notifyAddIterator(g, IteratorCollection.iteratorToList(it));
    }

    @Override
    public void notifyAddGraph(Graph g, Graph added) {
        for (GraphListener l : this.listeners) {
            l.notifyAddGraph(g, added);
        }
    }

    @Override
    public void notifyDeleteTriple(Graph g, Triple t) {
        for (GraphListener l : this.listeners) {
            l.notifyDeleteTriple(g, t);
        }
    }

    @Override
    public void notifyDeleteArray(Graph g, Triple[] ts) {
        for (GraphListener l : this.listeners) {
            l.notifyDeleteArray(g, ts);
        }
    }

    @Override
    public void notifyDeleteList(Graph g, List<Triple> L) {
        for (GraphListener l : this.listeners) {
            l.notifyDeleteList(g, L);
        }
    }

    @Override
    public void notifyDeleteIterator(Graph g, List<Triple> L) {
        for (GraphListener l : this.listeners) {
            l.notifyDeleteIterator(g, L.iterator());
        }
    }

    @Override
    public void notifyDeleteIterator(Graph g, Iterator<Triple> it) {
        this.notifyDeleteIterator(g, IteratorCollection.iteratorToList(it));
    }

    @Override
    public void notifyDeleteGraph(Graph g, Graph removed) {
        for (GraphListener l : this.listeners) {
            l.notifyDeleteGraph(g, removed);
        }
    }

    @Override
    public void notifyEvent(Graph source, Object event) {
        for (GraphListener l : this.listeners) {
            l.notifyEvent(source, event);
        }
    }

    public static ExtendedIterator<Triple> notifyingRemove(final Graph g, Iterator<Triple> i) {
        return new TrackingTripleIterator(i){
            protected final GraphEventManager gem;
            {
                super(x0);
                this.gem = g.getEventManager();
            }

            @Override
            public void remove() {
                super.remove();
                this.gem.notifyDeleteTriple(g, this.current);
            }
        };
    }
}

