/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdfxml.xmlinput.impl;

import com.hp.hpl.jena.rdfxml.xmlinput.ARPErrorNumbers;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.Taint;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.TaintImpl;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.XMLBaselessContext;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.XMLContext;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.XMLHandler;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.Violation;
import org.xml.sax.SAXParseException;

public abstract class AbsXMLContext
implements ARPErrorNumbers {
    protected final String lang;
    protected final Taint langTaint;
    final Taint baseTaint;
    protected final IRI uri;
    protected final AbsXMLContext document;
    private static Pattern langPattern = Pattern.compile("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");

    protected AbsXMLContext(boolean useDoc, AbsXMLContext document, IRI uri, Taint baseT, String lang, Taint langT) {
        this.lang = lang;
        this.langTaint = langT;
        this.baseTaint = baseT;
        this.uri = uri;
        this.document = useDoc ? (document == null ? this : document) : null;
    }

    protected static Taint initTaint(XMLHandler h, IRI base) throws SAXParseException {
        TaintImpl rslt = new TaintImpl();
        AbsXMLContext.checkURI(h, rslt, base);
        return rslt;
    }

    public AbsXMLContext withBase(XMLHandler forErrors, String b) throws SAXParseException {
        TaintImpl taintB = new TaintImpl();
        IRI newB = this.resolveAsURI(forErrors, taintB, b, false);
        if (newB.isRelative()) {
            return new XMLBaselessContext(forErrors, 215, newB.create(""));
        }
        if (newB.hasViolation(false)) {
            return new XMLBaselessContext(forErrors, 214, newB);
        }
        return new XMLContext(this.keepDocument(forErrors), this.document, newB.create(""), taintB, this.lang, this.langTaint);
    }

    abstract boolean keepDocument(XMLHandler var1);

    protected AbsXMLContext withLang(XMLHandler forErrors, String l) throws SAXParseException {
        TaintImpl taint = new TaintImpl();
        this.checkXMLLang(forErrors, taint, l);
        return this.clone(this.uri, this.baseTaint, l, taint);
    }

    abstract AbsXMLContext clone(IRI var1, Taint var2, String var3, Taint var4);

    public String getLang(Taint taint) {
        if (this.langTaint.isTainted()) {
            taint.taint();
        }
        return this.lang;
    }

    final IRI resolveAsURI(XMLHandler forErrors, Taint taintMe, String relUri) throws SAXParseException {
        return this.resolveAsURI(forErrors, taintMe, relUri, true);
    }

    final IRI resolveAsURI(XMLHandler forErrors, Taint taintMe, String relUri, boolean checkBaseUse) throws SAXParseException {
        IRI rslt = this.uri.create(relUri);
        if (checkBaseUse) {
            this.checkBaseUse(forErrors, taintMe, relUri, rslt);
        }
        AbsXMLContext.checkURI(forErrors, taintMe, rslt);
        return rslt;
    }

    abstract void checkBaseUse(XMLHandler var1, Taint var2, String var3, IRI var4) throws SAXParseException;

    protected static void checkURI(XMLHandler forErrors, Taint taintMe, IRI rslt) throws SAXParseException {
        if (rslt.hasViolation(false)) {
            Iterator<Violation> it = rslt.violations(false);
            while (it.hasNext()) {
                Violation irie = it.next();
                String msg = irie.getShortMessage();
                String uri = rslt.toString();
                if (irie.getViolationCode() == 57 && irie.getComponent() == 2) {
                    if (forErrors.allowRelativeURIs()) continue;
                    forErrors.warning(taintMe, 136, "Relative URIs are not permitted in RDF: specifically <" + rslt.toString() + ">");
                    continue;
                }
                forErrors.warning(taintMe, 107, "Bad URI: " + msg);
            }
        }
    }

    public String resolve(XMLHandler forErrors, Taint taintMe, String u) throws SAXParseException {
        return this.resolveAsURI(forErrors, taintMe, u, true).toString();
    }

    private void checkXMLLang(XMLHandler arp, Taint taintMe, String newLang) throws SAXParseException {
        if (newLang.equals("")) {
            return;
        }
        if (newLang.equalsIgnoreCase("und")) {
            arp.warning(taintMe, 116, "Bad language tag: " + newLang + " (not allowed)");
        }
        if (!langPattern.matcher(newLang).matches()) {
            arp.warning(taintMe, 116, "Bad language tag: " + newLang);
        }
    }
}

