/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.assembler.DatasetAssemblerVocab;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.modify.GraphStoreNull;
import com.hp.hpl.jena.sparql.modify.GraphStoreNullTransactional;
import org.apache.jena.atlas.logging.Log;

public class DatasetNullAssembler
extends AssemblerBase
implements Assembler {
    public static Resource getType() {
        return DatasetAssemblerVocab.tDatasetNull;
    }

    @Override
    public Object open(Assembler a, Resource root, Mode mode) {
        boolean transactional = true;
        if (root.hasProperty(DatasetAssemblerVocab.pTransactional)) {
            Node b = root.getProperty(DatasetAssemblerVocab.pTransactional).getObject().asNode();
            NodeValue nv = NodeValue.makeNode(b);
            if (nv.isBoolean()) {
                transactional = nv.getBoolean();
            } else {
                Log.warn(DatasetNullAssembler.class, "Failed to recognize value for transactional setting (ignored): " + b);
            }
        }
        GraphStoreNull dsg = transactional ? new GraphStoreNullTransactional() : new GraphStoreNull();
        return DatasetFactory.create(dsg);
    }
}

