/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.cep.api;

import eu.larkc.csparql.cep.api.RdfQuadruple;
import eu.larkc.csparql.cep.api.TestGenerator;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class GlueTestGenerator
extends TestGenerator {
    private final List<RdfQuadruple> list;
    private final int index;

    public GlueTestGenerator(String filename) throws IOException, ParseException {
        super("http://www.glue.org/glue");
        String ln;
        this.index = 0;
        System.out.println("reading file...");
        this.list = new LinkedList<RdfQuadruple>();
        BufferedReader rd = new BufferedReader(new FileReader(filename));
        long first = 0L;
        long linenumeber = 1L;
        while ((ln = rd.readLine()) != null) {
            if (ln.startsWith("#") | ln.startsWith("@") | ln.equals("") | ln.startsWith(" ")) continue;
            String[] parts = ln.split(" ");
            parts = this.joinParts(parts);
            SimpleDateFormat dfparser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            String cleanTimestamp = parts[3].replaceAll("\"", "").substring(0, parts[3].length() - 16);
            Date dDate = dfparser.parse(cleanTimestamp);
            Calendar cal = Calendar.getInstance();
            cal.setTime(dDate);
            long timestamp2 = cal.getTimeInMillis();
            RdfQuadruple q = new RdfQuadruple(parts[0], parts[1], parts[2], timestamp2);
            ((LinkedList)this.list).addFirst(q);
        }
        System.out.println(this.list.size() + " read");
    }

    private String[] joinParts(String[] parts) {
        String[] newparts = new String[4];
        newparts[0] = parts[0].substring(1, parts[0].length() - 1);
        newparts[1] = parts[1].substring(1, parts[1].length() - 1);
        newparts[2] = "";
        if (parts[2].indexOf("<") == 0) {
            newparts[2] = parts[2].substring(1, parts[2].length() - 1);
        } else {
            for (int i = 2; i < parts.length - 2; ++i) {
                newparts[2] = newparts[2] + parts[i] + " ";
            }
            newparts[2] = newparts[2].trim();
        }
        newparts[3] = parts[parts.length - 2];
        return newparts;
    }

    @Override
    public void run() {
        long referenceTime = this.list.get(0).getTimestamp();
        System.out.println("referenceTime: " + referenceTime);
        long streamedTriples = 0L;
        while (!this.list.isEmpty()) {
            RdfQuadruple q = this.list.remove(0);
            long t = q.getTimestamp();
            long timeToWait = t - referenceTime;
            referenceTime = t;
            ++streamedTriples;
            try {
                if (timeToWait > 0L) {
                    System.out.println("Streamed Triples: " + streamedTriples + " time to wait: " + timeToWait);
                }
                Thread.currentThread();
                Thread.sleep(timeToWait);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            this.put(q);
        }
    }
}

