/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.cep.esper;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPServiceProviderManager;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.EPStatementState;
import com.espertech.esper.client.time.CurrentTimeEvent;
import eu.larkc.csparql.cep.api.CepEngine;
import eu.larkc.csparql.cep.api.CepQuery;
import eu.larkc.csparql.cep.api.RdfQuadruple;
import eu.larkc.csparql.cep.api.RdfSnapshot;
import eu.larkc.csparql.cep.api.RdfStream;
import eu.larkc.csparql.cep.esper.EsperInjecter;
import eu.larkc.csparql.cep.esper.EsperQuery;
import eu.larkc.csparql.cep.esper.QueryListener;
import eu.larkc.csparql.common.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsperEngine
implements CepEngine {
    private EPServiceProvider epService = null;
    private Map<String, CepQuery> queries = null;
    private Collection<RdfStream> streams = null;
    private Map<String, EPStatement> statements = null;
    private final Configuration configuration = new Configuration();
    private ArrayBlockingQueue<RdfQuadruple> queue;
    private boolean enableInjecter;
    private Long currentSystemTime;
    private Long currentSystemLastTickTime;
    private boolean isSysTimeInit = false;
    private long timeStampTick = 1000L;
    private List<RdfQuadruple> quadAtBoundary = new ArrayList<RdfQuadruple>();
    protected final Logger logger = LoggerFactory.getLogger(EsperEngine.class);

    @Override
    public Collection<CepQuery> getAllQueries() {
        return this.queries.values();
    }

    @Override
    public Collection<RdfStream> getAllRegisteredStreams() {
        return this.streams;
    }

    @Override
    public void initialize() {
        if (Config.INSTANCE.isEsperUsingExternalTimestamp()) {
            this.configuration.getEngineDefaults().getThreading().setInternalTimerEnabled(!Config.INSTANCE.isEsperUsingExternalTimestamp());
            this.timeStampTick = Config.INSTANCE.getTimeStampTick();
        }
        this.epService = EPServiceProviderManager.getDefaultProvider(this.configuration);
        this.epService.initialize();
        this.queries = new HashMap<String, CepQuery>();
        this.streams = new ArrayList<RdfStream>();
        this.statements = new HashMap<String, EPStatement>();
    }

    public void setUpInjecter(int queueDimension) {
        if (queueDimension == 0) {
            this.enableInjecter = false;
        } else {
            this.enableInjecter = true;
            this.queue = new ArrayBlockingQueue(queueDimension);
            EsperInjecter esj = new EsperInjecter(this.queue, this);
            Thread esjThread = new Thread(esj);
            esjThread.start();
        }
    }

    public EPServiceProvider getEpService() {
        return this.epService;
    }

    public void setEpService(EPServiceProvider epService) {
        this.epService = epService;
    }

    @Override
    public void registerStream(RdfStream p) {
        String un = p.uniqueName();
        this.epService.getEPAdministrator().getConfiguration().addEventType(un, RdfQuadruple.class);
        p.addObserver(this);
        this.streams.add(p);
    }

    @Override
    public void unregisterQuery(String id) {
        this.queries.remove(id);
    }

    @Override
    public RdfSnapshot registerQuery(String query2, String id) {
        EsperQuery qry = new EsperQuery(query2);
        this.queries.put(id, qry);
        EPStatement stmt = this.epService.getEPAdministrator().createEPL(query2);
        this.statements.put(id, stmt);
        QueryListener l = new QueryListener(id);
        stmt.addListener(l);
        return l;
    }

    @Override
    public void destroy() {
        this.epService.destroy();
    }

    @Override
    public void startQuery(String id) {
        EPStatement s = this.getStatementById(id);
        if (s != null) {
            s.start();
        }
    }

    @Override
    public void stopQuery(String id) {
        EPStatementState state;
        EPStatement s = this.getStatementById(id);
        if (s != null && (state = s.getState()).compareTo(EPStatementState.STOPPED) != 0) {
            s.stop();
        }
    }

    private EPStatement getStatementById(String id) {
        if (this.statements.containsKey(id)) {
            return this.statements.get(id);
        }
        return null;
    }

    @Override
    public void unregisterStream(RdfStream stream) {
        this.streams.remove(stream);
    }

    @Override
    public String getCepEngineType() {
        return "esper";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        RdfStream s = (RdfStream)o;
        RdfQuadruple q = (RdfQuadruple)arg;
        q.setStreamName(s.getIRI());
        if (!this.enableInjecter) {
            this.currentSystemTime = this.setCurrentTimeAndSentEvent(q);
        } else {
            ArrayBlockingQueue<RdfQuadruple> arrayBlockingQueue = this.queue;
            synchronized (arrayBlockingQueue) {
                try {
                    this.queue.add(q);
                }
                catch (IllegalStateException e2) {
                    System.out.println("Queue Full");
                }
            }
        }
        q = null;
    }

    @Override
    public Long getCurrentTime() {
        return this.currentSystemTime;
    }

    @Override
    public Long setCurrentTimeAndSentEvent(RdfQuadruple q) {
        long inputTime = q.getTimestamp();
        if (!this.isSysTimeInit) {
            long initTime = inputTime / this.timeStampTick * this.timeStampTick;
            this.epService.getEPRuntime().sendEvent(new CurrentTimeEvent(initTime));
            this.isSysTimeInit = true;
            this.currentSystemTime = initTime;
            this.currentSystemLastTickTime = initTime;
            this.currentSystemTime = inputTime;
            this.epService.getEPRuntime().sendEvent(q);
            this.epService.getEPRuntime().sendEvent(new CurrentTimeEvent(inputTime));
            return this.currentSystemTime;
        }
        while (inputTime > this.currentSystemLastTickTime + this.timeStampTick) {
            if (this.quadAtBoundary.size() > 0) {
                long boundayTime = this.quadAtBoundary.get(0).getTimestamp();
                for (RdfQuadruple tempQ : this.quadAtBoundary) {
                    this.epService.getEPRuntime().sendEvent(tempQ);
                }
                this.quadAtBoundary = new ArrayList<RdfQuadruple>();
                this.currentSystemTime = boundayTime;
                Object object = this;
                Long.valueOf(((EsperEngine)object).currentSystemLastTickTime + this.timeStampTick);
                ((EsperEngine)object).currentSystemLastTickTime = ((EsperEngine)object).currentSystemLastTickTime;
                this.epService.getEPRuntime().sendEvent(new CurrentTimeEvent(this.currentSystemTime));
                object = this;
                Long.valueOf(((EsperEngine)object).currentSystemTime + 1L);
                ((EsperEngine)object).currentSystemTime = ((EsperEngine)object).currentSystemTime;
                this.epService.getEPRuntime().sendEvent(new CurrentTimeEvent(this.currentSystemTime));
                continue;
            }
            EsperEngine boundayTime = this;
            Long.valueOf(boundayTime.currentSystemLastTickTime + this.timeStampTick);
            boundayTime.currentSystemLastTickTime = boundayTime.currentSystemLastTickTime;
            this.currentSystemTime = this.currentSystemLastTickTime + 1L;
            this.epService.getEPRuntime().sendEvent(new CurrentTimeEvent(this.currentSystemTime));
        }
        if (inputTime == this.currentSystemLastTickTime + this.timeStampTick) {
            this.quadAtBoundary.add(q);
        } else if (inputTime < this.currentSystemLastTickTime + this.timeStampTick) {
            long boundayTime;
            if (this.quadAtBoundary.size() > 0 && inputTime < (boundayTime = this.quadAtBoundary.get(0).getTimestamp())) {
                throw new RuntimeException("unordered stream");
            }
            if (this.currentSystemTime != inputTime) {
                this.currentSystemTime = inputTime;
                this.epService.getEPRuntime().sendEvent(new CurrentTimeEvent(inputTime));
            }
            this.epService.getEPRuntime().sendEvent(q);
        }
        return this.currentSystemTime;
    }
}

