/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.common;

import eu.larkc.csparql.common.RDFTuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class RDFTable
implements Collection<RDFTuple> {
    private final List<String> names = new ArrayList<String>();
    private final List<RDFTuple> tuples = new ArrayList<RDFTuple>();
    private String jsonSerialization = new String();

    public String getJsonSerialization() {
        return this.jsonSerialization;
    }

    public void setJsonSerialization(String jsonSerialization) {
        this.jsonSerialization = jsonSerialization;
    }

    public boolean isGraph() {
        return true;
    }

    public RDFTable(String ... fieldsNames) {
        for (String fn : fieldsNames) {
            this.names.add(fn);
        }
    }

    public RDFTable(List<String> fieldsNames) {
        for (String fn : fieldsNames) {
            this.names.add(fn);
        }
    }

    public void add(String fieldName, String fieldDefaultValue) {
        this.names.add(fieldName);
        for (RDFTuple t : this.tuples) {
            t.addFields(fieldDefaultValue);
        }
    }

    public void add(Iterable<RDFTuple> tuplesToAdd) {
        for (RDFTuple tta : tuplesToAdd) {
            this.add(tta);
        }
    }

    @Override
    public boolean add(RDFTuple tupleToAdd) {
        return this.getTuples().add(tupleToAdd);
    }

    @Override
    public int size() {
        return this.getTuples().size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String n : this.names) {
            sb = sb.append(n).append("\t");
        }
        sb.append("\n");
        for (RDFTuple t : this.getTuples()) {
            sb = sb.append(t.toString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean addAll(Collection<? extends RDFTuple> arg0) {
        return this.getTuples().addAll(arg0);
    }

    @Override
    public void clear() {
        this.getTuples().clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.getTuples().contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.getTuples().containsAll(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.getTuples().isEmpty();
    }

    @Override
    public Iterator<RDFTuple> iterator() {
        return this.getTuples().iterator();
    }

    @Override
    public boolean remove(Object arg0) {
        return this.getTuples().remove(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.getTuples().removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.getTuples().retainAll(arg0);
    }

    @Override
    public Object[] toArray() {
        return this.getTuples().toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.getTuples().toArray(arg0);
    }

    public Collection<RDFTuple> getTuples() {
        return this.tuples;
    }

    public Collection<String> getNames() {
        return this.names;
    }
}

