/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.common.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.BasePathLocationStrategy;
import org.apache.commons.configuration2.io.ClasspathLocationStrategy;
import org.apache.commons.configuration2.io.CombinedLocationStrategy;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileSystemLocationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    public static final Config INSTANCE = new Config();
    private final Logger logger = LoggerFactory.getLogger(Config.class);
    private Configuration config;

    private Config() {
        try {
            List<FileLocationStrategy> subs = Arrays.asList(new BasePathLocationStrategy(), new FileSystemLocationStrategy(), new ClasspathLocationStrategy());
            CombinedLocationStrategy strategy = new CombinedLocationStrategy(subs);
            FileBasedConfigurationBuilder<PropertiesConfiguration> builder = new FileBasedConfigurationBuilder<PropertiesConfiguration>(PropertiesConfiguration.class);
            Parameters params = new Parameters();
            builder.configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)params.fileBased().setFileName("csparql.properties")).setLocationStrategy(strategy)});
            this.config = (Configuration)builder.getConfiguration();
            this.logger.debug("Configuration file successfully lodead");
        }
        catch (ConfigurationException e2) {
            this.logger.error("Error while lading the configuration file; default config will be used", e2);
            this.config = new BaseConfiguration();
            this.config.addProperty("esper.externaltime.enabled", false);
            this.config.addProperty("esper.externaltime.tick", 0);
        }
    }

    public boolean isEsperUsingExternalTimestamp() {
        return this.config.getBoolean("esper.externaltime.enabled");
    }

    public long getTimeStampTick() {
        return this.config.getLong("esper.externaltime.tick");
    }

    public void setConfigParams(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.config.setProperty(entry.getKey().toString(), entry.getValue());
        }
    }
}

