/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.core;

import eu.larkc.csparql.cep.api.CepEngine;
import eu.larkc.csparql.cep.api.CepQuery;
import eu.larkc.csparql.core.engine.CsparqlEngine;
import eu.larkc.csparql.core.engine.Reasoner;
import eu.larkc.csparql.core.new_parser.utility_files.Translator;
import eu.larkc.csparql.sparql.api.SparqlEngine;
import eu.larkc.csparql.sparql.api.SparqlQuery;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class Configuration {
    private static Configuration instance;
    private final String cepEngineName = "eu.larkc.csparql.cep.esper.EsperEngine";
    private final String reasonerName = "eu.larkc.csparql.core.engine.TransparentReasoner";
    private final String sparqlEngineName = "eu.larkc.csparql.sparql.jena.JenaEngine";
    private final String cepQueryName = "eu.larkc.csparql.cep.esper.EsperQuery";
    private final String sparqlQueryName = "eu.larkc.csparql.sparql.sesame.SesameQuery";
    private final String translatorName = "eu.larkc.csparql.core.new_parser.utility_files.CSparqlTranslator";

    public static Configuration getCurrentConfiguration() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    public Reasoner createReasoner() {
        Class<?> c = null;
        try {
            c = Class.forName(this.reasonerName);
            return (Reasoner)c.newInstance();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Translator createTranslator(CsparqlEngine engine) {
        Class<?> c = null;
        try {
            c = Class.forName(this.translatorName);
            Translator t = (Translator)c.newInstance();
            t.setEngine(engine);
            return t;
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public CepQuery createCepQuery(String command) {
        Class<?> c = null;
        CepQuery e2 = null;
        try {
            c = Class.forName(this.cepQueryName);
            Constructor<?>[] ctors = c.getConstructors();
            e2 = (CepQuery)ctors[0].newInstance(command);
            return e2;
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public SparqlQuery createSparqlQuery(String command) {
        Class<?> c = null;
        SparqlQuery e2 = null;
        try {
            Constructor<?>[] ctors;
            c = Class.forName(this.sparqlQueryName);
            for (Constructor<?> cc : ctors = c.getConstructors()) {
                if (cc.getParameterTypes().length != 1) continue;
                e2 = (SparqlQuery)cc.newInstance(command);
                return e2;
            }
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public CepEngine createCepEngine() {
        Class<?> c = null;
        CepEngine e2 = null;
        try {
            c = Class.forName(this.cepEngineName);
            e2 = (CepEngine)c.newInstance();
            return e2;
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public SparqlEngine createSparqlEngine() {
        Class<?> c = null;
        SparqlEngine e2 = null;
        try {
            c = Class.forName(this.sparqlEngineName);
            e2 = (SparqlEngine)c.newInstance();
            return e2;
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

