/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.core.engine;

import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import eu.larkc.csparql.cep.api.CepEngine;
import eu.larkc.csparql.cep.api.RdfQuadruple;
import eu.larkc.csparql.cep.api.RdfSnapshot;
import eu.larkc.csparql.cep.api.RdfStream;
import eu.larkc.csparql.cep.esper.EsperEngine;
import eu.larkc.csparql.common.RDFTable;
import eu.larkc.csparql.common.exceptions.ReasonerException;
import eu.larkc.csparql.common.utils.ReasonerChainingType;
import eu.larkc.csparql.core.Configuration;
import eu.larkc.csparql.core.engine.CsparqlEngine;
import eu.larkc.csparql.core.engine.CsparqlQueryResultProxy;
import eu.larkc.csparql.core.engine.Reasoner;
import eu.larkc.csparql.core.new_parser.utility_files.StreamInfo;
import eu.larkc.csparql.core.new_parser.utility_files.Translator;
import eu.larkc.csparql.core.streams.formats.CSparqlQuery;
import eu.larkc.csparql.core.streams.formats.TranslationException;
import eu.larkc.csparql.sparql.api.SparqlEngine;
import eu.larkc.csparql.sparql.jena.JenaEngine;
import java.io.BufferedReader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsparqlEngineImpl
implements Observer,
CsparqlEngine {
    private Configuration configuration = null;
    private Collection<CSparqlQuery> queries = null;
    private Map<String, RdfStream> streams = null;
    private Map<CSparqlQuery, RdfSnapshot> snapshots = null;
    private Map<CSparqlQuery, CsparqlQueryResultProxy> results = null;
    private CepEngine cepEngine = null;
    private SparqlEngine sparqlEngine = null;
    private Reasoner reasoner = null;
    protected final Logger logger = LoggerFactory.getLogger(CsparqlEngineImpl.class);

    @Override
    public Collection<CSparqlQuery> getAllQueries() {
        return this.queries;
    }

    @Override
    public void initialize() {
        this.configuration = Configuration.getCurrentConfiguration();
        this.queries = new ArrayList<CSparqlQuery>();
        this.streams = new HashMap<String, RdfStream>();
        this.snapshots = new HashMap<CSparqlQuery, RdfSnapshot>();
        this.results = new HashMap<CSparqlQuery, CsparqlQueryResultProxy>();
        this.sparqlEngine = this.configuration.createSparqlEngine();
        this.cepEngine = this.configuration.createCepEngine();
        this.reasoner = this.configuration.createReasoner();
        this.cepEngine.initialize();
        this.sparqlEngine.initialize();
        this.setPerformTimestampFunctionVariable(false);
        this.setUpInjecter(0);
    }

    @Override
    public void initialize(int queueDimension) {
        this.configuration = Configuration.getCurrentConfiguration();
        this.queries = new ArrayList<CSparqlQuery>();
        this.streams = new HashMap<String, RdfStream>();
        this.snapshots = new HashMap<CSparqlQuery, RdfSnapshot>();
        this.results = new HashMap<CSparqlQuery, CsparqlQueryResultProxy>();
        this.sparqlEngine = this.configuration.createSparqlEngine();
        this.cepEngine = this.configuration.createCepEngine();
        this.reasoner = this.configuration.createReasoner();
        this.cepEngine.initialize();
        this.sparqlEngine.initialize();
        this.setPerformTimestampFunctionVariable(false);
        this.setUpInjecter(queueDimension);
    }

    @Override
    public void initialize(boolean performTimestampFunction) {
        this.configuration = Configuration.getCurrentConfiguration();
        this.queries = new ArrayList<CSparqlQuery>();
        this.streams = new HashMap<String, RdfStream>();
        this.snapshots = new HashMap<CSparqlQuery, RdfSnapshot>();
        this.results = new HashMap<CSparqlQuery, CsparqlQueryResultProxy>();
        this.sparqlEngine = this.configuration.createSparqlEngine();
        this.cepEngine = this.configuration.createCepEngine();
        this.reasoner = this.configuration.createReasoner();
        this.cepEngine.initialize();
        this.sparqlEngine.initialize();
        this.setPerformTimestampFunctionVariable(performTimestampFunction);
        this.setUpInjecter(0);
    }

    @Override
    public void initialize(int queueDimension, boolean performTimestampFunction) {
        this.configuration = Configuration.getCurrentConfiguration();
        this.queries = new ArrayList<CSparqlQuery>();
        this.streams = new HashMap<String, RdfStream>();
        this.snapshots = new HashMap<CSparqlQuery, RdfSnapshot>();
        this.results = new HashMap<CSparqlQuery, CsparqlQueryResultProxy>();
        this.sparqlEngine = this.configuration.createSparqlEngine();
        this.cepEngine = this.configuration.createCepEngine();
        this.reasoner = this.configuration.createReasoner();
        this.cepEngine.initialize();
        this.sparqlEngine.initialize();
        this.setPerformTimestampFunctionVariable(performTimestampFunction);
        this.setUpInjecter(queueDimension);
    }

    public void setPerformTimestampFunctionVariable(boolean value) {
        if (this.sparqlEngine.getEngineType().equals("jena")) {
            JenaEngine je = (JenaEngine)this.sparqlEngine;
            je.setPerformTimestampFunctionVariable(value);
        }
    }

    public void setUpInjecter(int queueDimension) {
        if (this.cepEngine.getCepEngineType().equals("esper")) {
            EsperEngine ee = (EsperEngine)this.cepEngine;
            ee.setUpInjecter(queueDimension);
        }
    }

    @Override
    public boolean getInferenceStatus() {
        return this.sparqlEngine.getInferenceStatus();
    }

    @Override
    public void arrestInference(String queryId) {
        try {
            this.sparqlEngine.arrestInference(queryId);
        }
        catch (ReasonerException e2) {
            this.logger.error(e2.getMessage(), e2);
        }
    }

    @Override
    public void restartInference(String queryId) {
        try {
            this.sparqlEngine.restartInference(queryId);
        }
        catch (ReasonerException e2) {
            this.logger.error(e2.getMessage(), e2);
        }
    }

    @Override
    public void updateReasoner(String queryId) {
        this.sparqlEngine.updateReasoner(queryId);
    }

    @Override
    public void updateReasoner(String queryId, String rulesFile, ReasonerChainingType chainingType) {
        this.sparqlEngine.updateReasoner(queryId, rulesFile, chainingType);
    }

    @Override
    public void updateReasoner(String queryId, String rulesFile, ReasonerChainingType chainingType, String tBoxFile) {
        this.sparqlEngine.updateReasoner(queryId, rulesFile, chainingType, tBoxFile);
    }

    @Override
    public void execUpdateQueryOverDatasource(String queryBody) {
        this.sparqlEngine.execUpdateQueryOverDatasource(queryBody);
    }

    @Override
    public RDFTable evaluateGeneralQueryOverDatasource(String queryBody) {
        return this.sparqlEngine.evaluateGeneralQueryOverDatasource(queryBody);
    }

    @Override
    public void putStaticNamedModel(String iri2, String serialization) {
        this.sparqlEngine.putStaticNamedModel(iri2, serialization);
    }

    @Override
    public void removeStaticNamedModel(String iri2) {
        this.sparqlEngine.removeStaticNamedModel(iri2);
    }

    protected CSparqlQuery getQueryByID(String id) {
        for (CSparqlQuery q : this.queries) {
            if (!q.getId().equalsIgnoreCase(id)) continue;
            return q;
        }
        return null;
    }

    @Override
    public RdfStream registerStream(RdfStream s) {
        this.streams.put(s.getIRI(), s);
        this.cepEngine.registerStream(s);
        return s;
    }

    public void unregisterDataProvider(RdfStream provider) {
        this.streams.remove(provider);
    }

    private void unregisterAllQueries() {
        for (CSparqlQuery q : this.queries) {
            this.unregisterQuery(q.getId());
        }
    }

    @Override
    public void startQuery(String id) {
        this.cepEngine.startQuery(id);
    }

    @Override
    public void stopQuery(String id) {
        this.cepEngine.stopQuery(id);
    }

    private void unregisterQuery(CSparqlQuery q) {
        this.stopQuery(q.getId());
        if (q != null) {
            this.queries.remove(q);
        }
    }

    @Override
    public void unregisterQuery(String id) {
        CSparqlQuery q = this.getQueryByID(id);
        this.unregisterQuery(q);
    }

    @Override
    public void unregisterStream(String iri2) {
        RdfStream r = this.getStreamByIri(iri2);
        if (r == null) {
            return;
        }
        this.streams.remove(iri2);
    }

    @Override
    public CsparqlQueryResultProxy registerQuery(String command, boolean activateInference) throws ParseException {
        Translator t = Configuration.getCurrentConfiguration().createTranslator(this);
        CSparqlQuery query2 = null;
        try {
            query2 = t.translate(command);
        }
        catch (TranslationException e2) {
            throw new ParseException(e2.getMessage(), 0);
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        this.logger.debug("CEP query: {}", (Object)query2.getCepQuery().getQueryCommand());
        this.logger.debug("SPARQL query: {}", (Object)query2.getSparqlQuery().getQueryCommand().replace("\n", "").replace("\r", ""));
        this.sparqlEngine.parseSparqlQuery(query2.getSparqlQuery());
        RdfSnapshot s = this.cepEngine.registerQuery(query2.getCepQuery().getQueryCommand(), query2.getId());
        CsparqlQueryResultProxy result = new CsparqlQueryResultProxy(query2.getId());
        result.setSparqlQueryId(query2.getSparqlQuery().getId());
        result.setCepQueryId(query2.getCepQuery().getId());
        result.setName(query2.getName());
        this.queries.add(query2);
        this.snapshots.put(query2, s);
        this.results.put(query2, result);
        s.addObserver(this);
        if (activateInference) {
            this.logger.debug("RDFS reasoner");
            Resource config = ModelFactory.createDefaultModel().createResource().addProperty(ReasonerVocabulary.PROPsetRDFSLevel, "simple");
            com.hp.hpl.jena.reasoner.Reasoner reasoner = RDFSRuleReasonerFactory.theInstance().create(config);
            this.sparqlEngine.addReasonerToReasonerMap(query2.getSparqlQuery().getId(), reasoner);
        }
        return result;
    }

    @Override
    public CsparqlQueryResultProxy registerQuery(String command, boolean activateInference, String tBoxFileSerialization) throws ParseException {
        Translator t = Configuration.getCurrentConfiguration().createTranslator(this);
        CSparqlQuery query2 = null;
        try {
            query2 = t.translate(command);
        }
        catch (TranslationException e2) {
            throw new ParseException(e2.getMessage(), 0);
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        this.logger.debug("CEP query: {}", (Object)query2.getCepQuery().getQueryCommand());
        this.logger.debug("SPARQL query: {}", (Object)query2.getSparqlQuery().getQueryCommand().replace("\n", "").replace("\r", ""));
        this.sparqlEngine.parseSparqlQuery(query2.getSparqlQuery());
        RdfSnapshot s = this.cepEngine.registerQuery(query2.getCepQuery().getQueryCommand(), query2.getId());
        CsparqlQueryResultProxy result = new CsparqlQueryResultProxy(query2.getId());
        result.setSparqlQueryId(query2.getSparqlQuery().getId());
        result.setCepQueryId(query2.getCepQuery().getId());
        result.setName(query2.getName());
        this.queries.add(query2);
        this.snapshots.put(query2, s);
        this.results.put(query2, result);
        s.addObserver(this);
        if (activateInference) {
            this.logger.debug("RDFS reasoner");
            Resource config = ModelFactory.createDefaultModel().createResource().addProperty(ReasonerVocabulary.PROPsetRDFSLevel, "simple");
            com.hp.hpl.jena.reasoner.Reasoner reasoner = RDFSRuleReasonerFactory.theInstance().create(config);
            this.sparqlEngine.addReasonerToReasonerMap(query2.getSparqlQuery().getId(), reasoner);
        }
        return result;
    }

    @Override
    public CsparqlQueryResultProxy registerQuery(String command, boolean activateInference, String rulesFileSerialization, ReasonerChainingType chainingType) throws ParseException {
        Translator t = Configuration.getCurrentConfiguration().createTranslator(this);
        CSparqlQuery query2 = null;
        try {
            query2 = t.translate(command);
        }
        catch (TranslationException e2) {
            throw new ParseException(e2.getMessage(), 0);
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        this.logger.debug("CEP query: {}", (Object)query2.getCepQuery().getQueryCommand());
        this.logger.debug("SPARQL query: {}", (Object)query2.getSparqlQuery().getQueryCommand().replace("\n", "").replace("\r", ""));
        this.sparqlEngine.parseSparqlQuery(query2.getSparqlQuery());
        RdfSnapshot s = this.cepEngine.registerQuery(query2.getCepQuery().getQueryCommand(), query2.getId());
        CsparqlQueryResultProxy result = new CsparqlQueryResultProxy(query2.getId());
        result.setSparqlQueryId(query2.getSparqlQuery().getId());
        result.setCepQueryId(query2.getCepQuery().getId());
        result.setName(query2.getName());
        this.queries.add(query2);
        this.snapshots.put(query2, s);
        this.results.put(query2, result);
        s.addObserver(this);
        if (activateInference) {
            this.logger.debug("Generic Rule Engine");
            GenericRuleReasoner reasoner = new GenericRuleReasoner(Rule.parseRules(Rule.rulesParserFromReader(new BufferedReader(new StringReader(rulesFileSerialization)))));
            switch (chainingType) {
                case BACKWARD: {
                    reasoner.setParameter(ReasonerVocabulary.PROPruleMode, "backward");
                    break;
                }
                case FORWARD: {
                    reasoner.setParameter(ReasonerVocabulary.PROPruleMode, "forward");
                    break;
                }
                case HYBRID: {
                    reasoner.setParameter(ReasonerVocabulary.PROPruleMode, "hybrid");
                    break;
                }
                default: {
                    reasoner.setParameter(ReasonerVocabulary.PROPruleMode, "forward");
                }
            }
            this.sparqlEngine.addReasonerToReasonerMap(query2.getSparqlQuery().getId(), reasoner);
        }
        return result;
    }

    @Override
    public CsparqlQueryResultProxy registerQuery(String command, boolean activateInference, String rulesFileSerialization, ReasonerChainingType chainingType, String tBoxFileSerialization) throws ParseException {
        Translator t = Configuration.getCurrentConfiguration().createTranslator(this);
        CSparqlQuery query2 = null;
        try {
            query2 = t.translate(command);
        }
        catch (TranslationException e2) {
            throw new ParseException(e2.getMessage(), 0);
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        this.logger.debug("CEP query: {}", (Object)query2.getCepQuery().getQueryCommand());
        this.logger.debug("SPARQL query: {}", (Object)query2.getSparqlQuery().getQueryCommand().replace("\n", "").replace("\r", ""));
        this.sparqlEngine.parseSparqlQuery(query2.getSparqlQuery());
        RdfSnapshot s = this.cepEngine.registerQuery(query2.getCepQuery().getQueryCommand(), query2.getId());
        CsparqlQueryResultProxy result = new CsparqlQueryResultProxy(query2.getId());
        result.setSparqlQueryId(query2.getSparqlQuery().getId());
        result.setCepQueryId(query2.getCepQuery().getId());
        result.setName(query2.getName());
        this.queries.add(query2);
        this.snapshots.put(query2, s);
        this.results.put(query2, result);
        s.addObserver(this);
        if (activateInference) {
            this.logger.debug("Generic Rule Engine");
            com.hp.hpl.jena.reasoner.Reasoner reasoner = new GenericRuleReasoner(Rule.parseRules(Rule.rulesParserFromReader(new BufferedReader(new StringReader(rulesFileSerialization)))));
            switch (chainingType) {
                case BACKWARD: {
                    reasoner.setParameter(ReasonerVocabulary.PROPruleMode, "backward");
                    break;
                }
                case FORWARD: {
                    reasoner.setParameter(ReasonerVocabulary.PROPruleMode, "forward");
                    break;
                }
                case HYBRID: {
                    reasoner.setParameter(ReasonerVocabulary.PROPruleMode, "hybrid");
                    break;
                }
                default: {
                    reasoner.setParameter(ReasonerVocabulary.PROPruleMode, "forward");
                }
            }
            try {
                reasoner = reasoner.bindSchema(ModelFactory.createDefaultModel().read(new StringReader(tBoxFileSerialization), null, "RDF/XML"));
            }
            catch (Exception e4) {
                try {
                    reasoner = reasoner.bindSchema(ModelFactory.createDefaultModel().read(new StringReader(tBoxFileSerialization), null, "N-TRIPLE"));
                }
                catch (Exception e1) {
                    try {
                        reasoner = reasoner.bindSchema(ModelFactory.createDefaultModel().read(new StringReader(tBoxFileSerialization), null, "TURTLE"));
                    }
                    catch (Exception e2) {
                        try {
                            reasoner = reasoner.bindSchema(ModelFactory.createDefaultModel().read(new StringReader(tBoxFileSerialization), null, "RDF/JSON"));
                        }
                        catch (Exception e3) {
                            this.logger.error(e4.getMessage(), e3);
                        }
                    }
                }
            }
            this.sparqlEngine.addReasonerToReasonerMap(query2.getSparqlQuery().getId(), reasoner);
        }
        return result;
    }

    @Override
    public void destroy() {
        this.unregisterAllQueries();
        this.cepEngine.destroy();
    }

    private boolean isStreamUsedInQuery(CSparqlQuery csparqlquery, String streamName) {
        for (StreamInfo si : csparqlquery.getStreams()) {
            if (!si.getIri().equalsIgnoreCase(streamName)) continue;
            return true;
        }
        return false;
    }

    private void notifySubscribers(CSparqlQuery csparqlquery, RDFTable result) {
        CsparqlQueryResultProxy res = this.results.get(csparqlquery);
        res.notify(result);
    }

    @Override
    public RdfStream getStreamByIri(String iri2) {
        if (this.streams.containsKey(iri2)) {
            return this.streams.get(iri2);
        }
        return null;
    }

    @Override
    public void update(Observable o, Object arg) {
        RdfSnapshot r = (RdfSnapshot)o;
        List quads = (List)arg;
        this.logger.debug("current time: {}", (Object)this.cepEngine.getCurrentTime());
        CSparqlQuery csparqlquery = this.getQueryByID(r.getId());
        RdfSnapshot augmentedSnapshot = this.reasoner.augment(r);
        this.snapshots.put(csparqlquery, augmentedSnapshot);
        this.sparqlEngine.clean();
        long count = 0L;
        for (RdfQuadruple q : quads) {
            if (!this.isStreamUsedInQuery(csparqlquery, q.getStreamName())) continue;
            this.sparqlEngine.addStatement(q.getSubject(), q.getPredicate(), q.getObject(), q.getTimestamp());
            ++count;
        }
        if (count == 0L) {
            return;
        }
        RDFTable result = this.sparqlEngine.evaluateQuery(csparqlquery.getSparqlQuery());
        this.notifySubscribers(csparqlquery, result);
    }
}

