/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.core.engine;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import eu.larkc.csparql.cep.api.RdfQuadruple;
import eu.larkc.csparql.cep.api.RdfStream;
import eu.larkc.csparql.common.RDFTable;
import eu.larkc.csparql.common.RDFTuple;
import java.util.GregorianCalendar;
import java.util.Observable;
import java.util.Observer;

public class RDFStreamFormatter
extends RdfStream
implements Observer {
    public RDFStreamFormatter(String iri2) {
        super(iri2);
    }

    @Override
    public void update(Observable o, Object arg) {
        RDFTable q = (RDFTable)arg;
        Model model = ModelFactory.createDefaultModel();
        int numberOfTriplesInRDFTable = 0;
        for (RDFTuple t : q) {
            ++numberOfTriplesInRDFTable;
            String subject = t.get(0);
            String property = t.get(1);
            Resource rSubject = model.createResource(subject);
            Property pProperty = model.createProperty(property);
            String object = t.get(2);
            String[] objectParts = object.split("\\^\\^");
            if (objectParts.length > 1) {
                TypeMapper tm = TypeMapper.getInstance();
                RDFDatatype RDFdt = tm.getTypeByName(objectParts[1]);
                Literal lObject = model.createTypedLiteral(objectParts[0].replaceAll("\"", ""), RDFdt);
                rSubject.addLiteral(pProperty, lObject);
                continue;
            }
            Resource rObject = model.createResource(object);
            rSubject.addProperty(pProperty, rObject);
        }
        if (numberOfTriplesInRDFTable > 0) {
            StmtIterator si = model.listStatements();
            while (si.hasNext()) {
                Statement s = (Statement)si.next();
                RdfQuadruple quad = new RdfQuadruple(s.getSubject().toString(), s.getPredicate().toString(), s.getObject().toString(), new GregorianCalendar().getTimeInMillis());
                this.put(quad);
            }
        }
    }
}

