/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.core.new_parser.utility_files;

import eu.larkc.csparql.cep.api.RdfStream;
import eu.larkc.csparql.core.engine.CsparqlEngine;
import eu.larkc.csparql.core.new_parser.utility_files.LogicalWindow;
import eu.larkc.csparql.core.new_parser.utility_files.PhysicalWindow;
import eu.larkc.csparql.core.new_parser.utility_files.StreamInfo;
import eu.larkc.csparql.core.new_parser.utility_files.TimeUtils;
import eu.larkc.csparql.core.new_parser.utility_files.Window;
import eu.larkc.csparql.core.streams.formats.TranslationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class EplProducer {
    private CsparqlEngine engine;
    private ArrayList<StreamInfo> streams;

    public EplProducer(CsparqlEngine engine, ArrayList<StreamInfo> streams) {
        this.engine = engine;
        this.streams = streams;
    }

    public String convertStreamIri(String uri) throws TranslationException {
        RdfStream s = this.engine.getStreamByIri(uri);
        if (s == null) {
            throw new TranslationException("IRI " + uri + " not found.");
        }
        return s.uniqueName();
    }

    public Set<String> produceEpl() throws TranslationException {
        HashSet<String> result = new HashSet<String>();
        for (StreamInfo si : this.streams) {
            StringBuffer s = new StringBuffer("select irstream * from ");
            String iri2 = si.getIri();
            if (iri2 == null) {
                TranslationException e2 = new TranslationException("Stream IRI " + iri2 + " not found");
                e2.setIri(iri2);
                throw e2;
            }
            s.append(this.convertStreamIri(iri2));
            s.append('.');
            Window w = si.getWindow();
            if (si.hasPhisicalWindow()) {
                PhysicalWindow ph = (PhysicalWindow)w;
                s.append("win:length_batch(");
                s.append(ph.getWindowRange());
                s.append(")");
                s.append(" output snapshot every ");
                s.append(ph.getWindowRange());
                s.append(" events");
            } else {
                LogicalWindow l = (LogicalWindow)w;
                String range = TimeUtils.getSeconds(l.getRangeDescription().getValue(), l.getRangeDescription().getTimeUnit());
                if (l.isTumbling()) {
                    s.append("win:time_batch(");
                    s.append(range);
                    s.append(")");
                } else {
                    s.append("win:time(");
                    s.append(range);
                    s.append(")");
                    s.append(" output snapshot every ");
                    String step = TimeUtils.getSeconds(l.getStepDescription().getValue(), l.getStepDescription().getTimeUnit());
                    s.append(step);
                }
            }
            result.add(s.toString());
        }
        return result;
    }
}

