/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.core.old_parser;

import eu.larkc.csparql.core.old_parser.Label;
import eu.larkc.csparql.core.old_parser.LogicalWindow;
import eu.larkc.csparql.core.old_parser.PhysicalWindow;
import eu.larkc.csparql.core.old_parser.RegistrationInfo;
import eu.larkc.csparql.core.old_parser.SparqlProducer1_0;
import eu.larkc.csparql.core.old_parser.StreamInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.ParseTree;
import org.antlr.runtime.tree.Tree;

public class TreeBox
extends ParseTree {
    private ParseTree pT;
    private TreeBox parent;
    private Label label;
    private int childIndex;

    TreeBox(Object o) {
        super(o);
    }

    @Override
    public void setParent(Tree t) {
        this.parent = (TreeBox)t;
    }

    @Override
    public TreeBox getParent() {
        if (this.parent == null) {
            return null;
        }
        return this.parent;
    }

    @Override
    public void addChild(Tree t) {
        super.addChild(t);
    }

    @Override
    public TreeBox getChild(int i) {
        return (TreeBox)super.getChild(i);
    }

    @Override
    public int getChildIndex() {
        return this.childIndex;
    }

    @Override
    public void setChildIndex(int value) {
        this.childIndex = value;
    }

    public ParseTree getParseTree() {
        return this.pT;
    }

    public void setParseTree(ParseTree pT) {
        this.pT = pT;
    }

    public void setLabel(Label l) {
        this.label = l;
    }

    public Label getLabel() {
        return this.label;
    }

    public Set<String> getVariables() {
        HashSet<String> var = new HashSet<String>();
        List<TreeBox> nodes = this.getNodesByText("var");
        for (TreeBox t : nodes) {
            var.add(t.getChild(0).getText());
        }
        return var;
    }

    public void printVariables() {
        System.out.print("Variables: ");
        Set<String> var = this.getVariables();
        for (String s : var) {
            System.out.print("<" + s + ">");
        }
        System.out.println();
    }

    public Set<StreamInfo> getStreams() {
        HashSet<StreamInfo> streams = new HashSet<StreamInfo>();
        List<TreeBox> streamsStatements = this.getNodesByText("datasetClauseStream");
        int nOfTriples = -1;
        for (TreeBox t : streamsStatements) {
            StreamInfo stream;
            List<TreeBox> tempNode = t.getNodesByText("iriRef");
            String uri = tempNode.get(0).getChild(0).getText();
            tempNode = t.getNodesByText("physicalWindow");
            if (!tempNode.isEmpty()) {
                nOfTriples = Integer.parseInt(tempNode.get(0).getChild(1).getText());
                PhysicalWindow pw = new PhysicalWindow(nOfTriples);
                stream = new StreamInfo(uri, pw);
            } else {
                String stepUnit;
                String step;
                tempNode = t.getNodesByText("logicalWindow");
                tempNode = tempNode.get(0).getNodesByText("timeRange");
                String timeRange = tempNode.get(0).getChild(0).getText();
                String[] rangeUnit = this.getRangeAndUnit(timeRange);
                timeRange = rangeUnit[0];
                String timeRangeUnit = rangeUnit[1];
                if (tempNode.size() == 2) {
                    String[] stepClauses = this.getRangeAndUnit(tempNode.get(1).getChild(0).getText());
                    step = stepClauses[0];
                    stepUnit = stepClauses[1];
                } else {
                    step = timeRange;
                    stepUnit = timeRangeUnit;
                }
                LogicalWindow lw = new LogicalWindow(Integer.parseInt(timeRange), RegistrationInfo.getUnitOfMeasure(timeRangeUnit), Integer.parseInt(step), RegistrationInfo.getUnitOfMeasure(stepUnit));
                stream = new StreamInfo(uri, lw);
            }
            streams.add(stream);
        }
        return streams;
    }

    private String[] getRangeAndUnit(String s) {
        char[] chars = s.toCharArray();
        for (int i = chars.length - 1; i >= 0; --i) {
            if (!Character.isDigit(chars[i])) continue;
            String[] ret = new String[]{s.substring(0, i + 1), s.substring(i + 1)};
            return ret;
        }
        return null;
    }

    public String getQueryName() {
        if (this.getQueryLanguage().equals((Object)QueryLanguages.SPARQL)) {
            return null;
        }
        String result = new String();
        if (this.getText().equals("queryName")) {
            return this.getChild(0).getText();
        }
        if (this.getChildren() != null) {
            for (Object o : this.getChildren()) {
                TreeBox t = (TreeBox)o;
                result = result + t.getQueryName();
            }
        }
        return result;
    }

    public boolean isCSparql() {
        TreeBox root = this.getRoot();
        return root.existNode("registration");
    }

    public TreeBox getRoot() {
        TreeBox root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public QueryLanguages getQueryLanguage() {
        TreeBox root = this.getRoot();
        if (root.isCSparql()) {
            return QueryLanguages.CSPARQL;
        }
        return QueryLanguages.SPARQL;
    }

    public RegistrationInfo getRegistrationInfo() {
        if (this.isCSparql()) {
            RegistrationInfo ri = null;
            List<TreeBox> registration = this.getNodesByText("registration");
            String timeRange = new String();
            String unit = new String();
            if (!registration.isEmpty()) {
                List<TreeBox> tempNode = registration.get(0).getNodesByText("timeRange");
                if (!tempNode.isEmpty()) {
                    timeRange = tempNode.get(0).getChild(0).getText();
                    unit = timeRange.substring(timeRange.length() - 1);
                    timeRange = timeRange.substring(0, timeRange.length() - 1);
                }
                RegistrationInfo.QueryType type = !(tempNode = registration.get(0).getNodesByText("stream")).isEmpty() ? RegistrationInfo.QueryType.STREAM : RegistrationInfo.QueryType.QUERY;
                ri = new RegistrationInfo(type, this.getQueryName(), Integer.parseInt(timeRange), RegistrationInfo.getUnitOfMeasure(unit));
            }
            return ri;
        }
        return null;
    }

    public static TreeBox create(ParseTree parseTree) {
        TreeBox t = new TreeBox(parseTree.payload);
        t.pT = parseTree;
        for (int i = 0; i < t.pT.getChildCount(); ++i) {
            TreeBox cb = TreeBox.create((ParseTree)t.pT.getChild(i));
            cb.setParent(t);
            t.addChild(cb);
        }
        return t;
    }

    public static TreeBox dupFullTreeDecorated(TreeBox t) {
        TreeBox tbx = TreeBox.create(t.getParseTree());
        TreeBox.decorate(tbx);
        return tbx;
    }

    public static void decorate(TreeBox tbx) {
        tbx.deepFirstDecoration(tbx, 0);
    }

    private int deepFirstDecoration(TreeBox tbx, int n) {
        if (tbx.getParent() == null) {
            Label l = new Label(0, 0, 0);
            tbx.setLabel(l);
        }
        if (tbx.getChildren() != null && tbx.getChildren().size() > 0) {
            for (int i = 0; i < tbx.children.size(); ++i) {
                Label l = new Label(++n, tbx.getLabel().getDeepLevel() + 1, i);
                tbx.getChild(i).setLabel(l);
                if (tbx.getChild(i).getChildren() == null || tbx.getChild(i).getChildren().size() <= 0) continue;
                n = this.deepFirstDecoration(tbx.getChild(i), n);
            }
        }
        return n;
    }

    public boolean existNode(String nodeName) {
        boolean result = false;
        if (this.getText().equalsIgnoreCase(nodeName)) {
            return true;
        }
        if (this.children != null) {
            for (Object o : this.children) {
                TreeBox t = (TreeBox)o;
                result = t.existNode(nodeName);
                if (!result) continue;
                return result;
            }
        }
        return result;
    }

    public List<TreeBox> getNodesByText(String nodeName) {
        ArrayList<TreeBox> nodes = new ArrayList<TreeBox>();
        if (this.getText().equals(nodeName)) {
            nodes.add(this);
        }
        if (this.children != null) {
            for (Object o : this.children) {
                TreeBox t = (TreeBox)o;
                nodes.addAll(t.getNodesByText(nodeName));
            }
        }
        nodes.remove(null);
        return nodes;
    }

    public void printFullTree() {
        for (int n = 0; n < this.getLabel().getDeepLevel(); ++n) {
            System.out.print(" ");
        }
        System.out.println("Livello" + this.getLabel().getDeepLevel() + " - ID:" + this.getLabel().getId() + " - Testo:" + this.getText() + " - #Figli:" + this.getChildCount());
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChild(i).printFullTree();
        }
    }

    public List<TreeBox> getLeaves() {
        ArrayList<TreeBox> leaves = new ArrayList<TreeBox>();
        if (this.payload instanceof Token && (this.children == null || this.children.isEmpty())) {
            if (!this.getText().equals("<EOF>")) {
                leaves.add(this);
            }
        } else if (this.children != null && !this.children.isEmpty()) {
            for (Object o : this.children) {
                TreeBox t = (TreeBox)o;
                leaves.addAll(t.getLeaves());
            }
        }
        return leaves;
    }

    @Override
    public String toInputString() {
        StringBuffer sb = new StringBuffer();
        this.printLeaves(sb);
        return sb.toString();
    }

    @Override
    public void _toStringLeaves(StringBuffer buf) {
        SparqlProducer1_0 sp = new SparqlProducer1_0();
        if (this.payload instanceof Token && !this.getText().equals("<EOF>")) {
            buf.append(sp.getTextWithSymbols(this));
            buf.append(" ");
            return;
        }
        for (int i = 0; this.children != null && i < this.children.size(); ++i) {
            ParseTree t = (ParseTree)this.children.get(i);
            t._toStringLeaves(buf);
        }
    }

    public void printLeaves(StringBuffer buf) {
        if (this.children == null || 0 == this.children.size()) {
            SparqlProducer1_0 sp = new SparqlProducer1_0();
            buf.append(sp.getTextWithSymbols(this));
            buf.append(" ");
            System.out.println(this.getText());
        } else {
            for (int i = 0; this.children != null && i < this.children.size(); ++i) {
                TreeBox t = (TreeBox)this.children.get(i);
                t.printLeaves(buf);
            }
        }
    }

    public static enum QueryLanguages {
        SPARQL,
        CSPARQL;

    }
}

