/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.core.streams.formats;

import eu.larkc.csparql.cep.api.CepQuery;
import eu.larkc.csparql.core.Configuration;
import eu.larkc.csparql.core.new_parser.utility_files.StreamInfo;
import eu.larkc.csparql.core.streams.formats.CSparqlQuery;
import eu.larkc.csparql.sparql.api.SparqlQuery;
import java.util.Collection;
import java.util.UUID;

public class CSparqlQueryImpl
implements CSparqlQuery {
    private String id = this.generateID();
    private String command = null;
    private CepQuery cepQuery = null;
    private SparqlQuery sparqlQuery = null;
    private Collection<StreamInfo> streams;
    private String name = null;

    public CSparqlQueryImpl(String cepQuery, String sparqlQuery, String cSparqlQuery, Collection<StreamInfo> streams, String name) {
        this.command = cSparqlQuery;
        this.sparqlQuery = Configuration.getCurrentConfiguration().createSparqlQuery(sparqlQuery);
        this.cepQuery = Configuration.getCurrentConfiguration().createCepQuery(cepQuery);
        this.streams = streams;
        this.name = name;
    }

    private String generateID() {
        return UUID.randomUUID().toString();
    }

    @Override
    public CepQuery getCepQuery() {
        return this.cepQuery;
    }

    @Override
    public String getQueryCommand() {
        return this.command;
    }

    @Override
    public SparqlQuery getSparqlQuery() {
        return this.sparqlQuery;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Collection<StreamInfo> getStreams() {
        return this.streams;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

