/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.sparql.jena;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.sparql.function.FunctionRegistry;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import eu.larkc.csparql.common.RDFTable;
import eu.larkc.csparql.common.RDFTuple;
import eu.larkc.csparql.common.data_source.Datasource;
import eu.larkc.csparql.common.exceptions.ReasonerException;
import eu.larkc.csparql.common.hardware_resource.Memory;
import eu.larkc.csparql.common.utils.ReasonerChainingType;
import eu.larkc.csparql.sparql.api.SparqlEngine;
import eu.larkc.csparql.sparql.api.SparqlQuery;
import eu.larkc.csparql.sparql.jena.common.JenaReasonerWrapper;
import eu.larkc.csparql.sparql.jena.data_source.JenaDatasource;
import eu.larkc.csparql.sparql.jena.ext.timestamp;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenaEngine
implements SparqlEngine {
    private Datasource jds = new JenaDatasource();
    private HashMap<String, JenaReasonerWrapper> reasonerMap = new HashMap();
    private boolean activateInference = false;
    private Model model = null;
    Map<String, Model> graphs = new HashMap<String, Model>();
    Map<Statement, Long> timestamps = new HashMap<Statement, Long>();
    private boolean performTimestampFunction = false;
    private Logger logger = LoggerFactory.getLogger(JenaEngine.class.getName());

    public void setPerformTimestampFunctionVariable(boolean value) {
        this.performTimestampFunction = value;
    }

    @Override
    public String getEngineType() {
        return "jena";
    }

    public JenaEngine() {
        FunctionRegistry.get().put("http://larkc.eu/csparql/sparql/jena/ext#timestamp", timestamp.class);
        timestamp.timestamps = this.timestamps;
    }

    @Override
    public void addStatement(String subject, String predicate, String object) {
        this.addStatement(subject, predicate, object, 0L);
    }

    @Override
    public void addStatement(String subject, String predicate, String object, long timestamp2) {
        StatementImpl s;
        String[] objectParts = object.split("\\^\\^");
        if (objectParts.length > 1) {
            TypeMapper tm = TypeMapper.getInstance();
            RDFDatatype d = tm.getTypeByName(objectParts[1]);
            Literal lObject = this.model.createTypedLiteral(objectParts[0].replaceAll("\"", ""), d);
            s = new StatementImpl(new ResourceImpl(subject), new PropertyImpl(predicate), lObject);
        } else {
            s = new StatementImpl(new ResourceImpl(subject), new PropertyImpl(predicate), new ResourceImpl(object));
        }
        if (this.performTimestampFunction && timestamp2 != 0L) {
            this.timestamps.put(s, new Long(timestamp2));
        }
        this.model.add(s);
    }

    @Override
    public void clean() {
        this.model.remove(this.model);
        this.timestamps.clear();
    }

    @Override
    public void destroy() {
        this.model.close();
        this.timestamps.clear();
    }

    @Override
    public RDFTable evaluateQuery(SparqlQuery query2) {
        QueryExecution qexec;
        long startTS = System.currentTimeMillis();
        Query q = QueryFactory.create(query2.getQueryCommand(), Syntax.syntaxSPARQL_11);
        for (String s : q.getGraphURIs()) {
            List<RDFTuple> list = this.jds.getNamedModel(s);
            for (RDFTuple t : list) {
                this.addStatement(t.get(0), t.get(1), t.get(2));
            }
        }
        if (this.reasonerMap.containsKey(query2.getId())) {
            if (this.reasonerMap.get(query2.getId()).isActive()) {
                Reasoner reasoner = (Reasoner)this.reasonerMap.get(query2.getId()).getReasoner();
                InfModel infmodel = ModelFactory.createInfModel(reasoner, this.model);
                qexec = QueryExecutionFactory.create(q, (Model)infmodel);
            } else {
                qexec = QueryExecutionFactory.create(q, this.model);
            }
        } else {
            qexec = QueryExecutionFactory.create(q, this.model);
        }
        RDFTable table = null;
        if (q.isSelectType()) {
            ResultSet resultSet = qexec.execSelect();
            table = new RDFTable(resultSet.getResultVars());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ResultSetRewindable tempResultSet = ResultSetFactory.makeRewindable(resultSet);
            ResultSetFormatter.outputAsJSON((OutputStream)bos, tempResultSet);
            table.setJsonSerialization(bos.toString());
            tempResultSet.reset();
            while (tempResultSet.hasNext()) {
                RDFTuple tuple = new RDFTuple();
                QuerySolution soln = tempResultSet.nextSolution();
                for (String s : table.getNames()) {
                    RDFNode n = soln.get(s);
                    if (n == null) {
                        tuple.addFields("");
                        continue;
                    }
                    tuple.addFields(this.format(n));
                }
                table.add(tuple);
            }
        } else if (q.isAskType()) {
            table = new RDFTable("Answer");
            RDFTuple tuple = new RDFTuple();
            tuple.addFields("" + qexec.execAsk());
            table.add(tuple);
        } else if (q.isDescribeType() || q.isConstructType()) {
            Model m = null;
            m = q.isDescribeType() ? qexec.execDescribe() : qexec.execConstruct();
            table = new RDFTable("Subject", "Predicate", "Object");
            StringWriter w = new StringWriter();
            m.write(w, "JSON-LD");
            table.setJsonSerialization(w.toString());
            StmtIterator it = m.listStatements();
            while (it.hasNext()) {
                RDFTuple tuple = new RDFTuple();
                Statement stm = (Statement)it.next();
                tuple.addFields(this.formatSubject(stm.getSubject()), this.formatPredicate(stm.getPredicate()), this.format(stm.getObject()));
                table.add(tuple);
            }
        }
        long endTS = System.currentTimeMillis();
        Object[] object = new Object[]{query2.getId(), endTS - startTS, table.size(), Memory.getTotalMemory(), Memory.getFreeMemory(), Memory.getMemoryUsage()};
        this.logger.debug("Information about execution of query {} \n Execution Time : {} \n Results Number : {} \n Total Memory : {} mb \n Free Memory : {} mb \n Memory Usage : {} mb", object);
        return table;
    }

    private String format(RDFNode n) {
        if (n.isLiteral()) {
            return "\"" + n.asLiteral().getLexicalForm() + "\"^^" + n.asLiteral().getDatatypeURI();
        }
        return n.toString();
    }

    private String formatPredicate(Property predicate) {
        return predicate.toString();
    }

    private String formatSubject(Resource subject) {
        return subject.toString();
    }

    @Override
    public void initialize() {
        this.model = ModelFactory.createDefaultModel();
    }

    private List<RDFTuple> modelToTupleList(Model m) {
        ArrayList<RDFTuple> list = new ArrayList<RDFTuple>();
        StmtIterator it = m.listStatements();
        while (it.hasNext()) {
            RDFTuple tuple = new RDFTuple();
            Statement stm = (Statement)it.next();
            tuple.addFields(this.formatSubject(stm.getSubject()), this.formatPredicate(stm.getPredicate()), this.format(stm.getObject()));
            list.add(tuple);
        }
        return list;
    }

    @Override
    public RDFTable evaluateGeneralQueryOverDatasource(String queryBody) {
        return this.jds.evaluateGeneralQuery(queryBody);
    }

    @Override
    public void execUpdateQueryOverDatasource(String queryBody) {
        this.jds.execUpdateQuery(queryBody);
    }

    @Override
    public void putStaticNamedModel(String iri2, String modelReference) {
        Model m = ModelFactory.createDefaultModel();
        try {
            m.read(iri2);
        }
        catch (Exception e2) {
            StringReader sr = new StringReader(modelReference);
            try {
                m.read(sr, null, "RDF/XML");
            }
            catch (Exception e1) {
                try {
                    sr = new StringReader(modelReference);
                    m.read(sr, null, "TURTLE");
                }
                catch (Exception e22) {
                    try {
                        sr = new StringReader(modelReference);
                        m.read(sr, null, "N-TRIPLE");
                    }
                    catch (Exception e3) {
                        sr = new StringReader(modelReference);
                        m.read(sr, null, "RDF/JSON");
                    }
                }
            }
            sr.close();
        }
        this.jds.putNamedModel(iri2, this.modelToTupleList(m));
    }

    @Override
    public void removeStaticNamedModel(String iri2) {
        this.jds.removeNamedModel(iri2);
    }

    @Override
    public Datasource getDataSource() {
        return this.jds;
    }

    @Override
    public void setReasonerMap(Object reasonerMap) {
        this.reasonerMap = (HashMap)reasonerMap;
    }

    @Override
    public void addReasonerToReasonerMap(String queryId, Object reasoner) {
        this.reasonerMap.put(queryId, new JenaReasonerWrapper(reasoner, true));
    }

    @Override
    public void arrestInference(String queryId) throws ReasonerException {
        JenaReasonerWrapper jrw = this.reasonerMap.get(queryId);
        if (jrw == null) {
            throw new ReasonerException("No reasoner for the specified query. Please add new reasoner using the updateReasoner method");
        }
        jrw.setActive(false);
        this.reasonerMap.put(queryId, jrw);
    }

    @Override
    public void restartInference(String queryId) throws ReasonerException {
        JenaReasonerWrapper jrw = this.reasonerMap.get(queryId);
        if (jrw == null) {
            throw new ReasonerException("No reasoner for the specified query. Please add new reasoner using the updateReasoner method");
        }
        jrw.setActive(true);
        this.reasonerMap.put(queryId, jrw);
    }

    @Override
    public void updateReasoner(String queryId) {
        Resource config = ModelFactory.createDefaultModel().createResource().addProperty(ReasonerVocabulary.PROPsetRDFSLevel, "simple");
        Reasoner reasoner = RDFSRuleReasonerFactory.theInstance().create(config);
        this.addReasonerToReasonerMap(queryId, reasoner);
    }

    @Override
    public void updateReasoner(String queryId, String rulesFile, ReasonerChainingType chainingType) {
        GenericRuleReasoner reasoner = new GenericRuleReasoner(Rule.parseRules(Rule.rulesParserFromReader(new BufferedReader(new StringReader(rulesFile)))));
        switch (chainingType) {
            case BACKWARD: {
                reasoner.setParameter(ReasonerVocabulary.PROPruleMode, "backward");
                break;
            }
            case FORWARD: {
                reasoner.setParameter(ReasonerVocabulary.PROPruleMode, "forward");
                break;
            }
            case HYBRID: {
                reasoner.setParameter(ReasonerVocabulary.PROPruleMode, "hybrid");
                break;
            }
            default: {
                reasoner.setParameter(ReasonerVocabulary.PROPruleMode, "forward");
            }
        }
        this.addReasonerToReasonerMap(queryId, reasoner);
    }

    @Override
    public void updateReasoner(String queryId, String rulesFile, ReasonerChainingType chainingType, String tBoxFile) {
        Reasoner reasoner = new GenericRuleReasoner(Rule.parseRules(Rule.rulesParserFromReader(new BufferedReader(new StringReader(rulesFile)))));
        switch (chainingType) {
            case BACKWARD: {
                reasoner.setParameter(ReasonerVocabulary.PROPruleMode, "backward");
                break;
            }
            case FORWARD: {
                reasoner.setParameter(ReasonerVocabulary.PROPruleMode, "forward");
                break;
            }
            case HYBRID: {
                reasoner.setParameter(ReasonerVocabulary.PROPruleMode, "hybrid");
                break;
            }
            default: {
                reasoner.setParameter(ReasonerVocabulary.PROPruleMode, "forward");
            }
        }
        try {
            reasoner = reasoner.bindSchema(ModelFactory.createDefaultModel().read(new StringReader(tBoxFile), null, "RDF/XML"));
        }
        catch (Exception e2) {
            try {
                reasoner = reasoner.bindSchema(ModelFactory.createDefaultModel().read(new StringReader(tBoxFile), null, "N-TRIPLE"));
            }
            catch (Exception e1) {
                try {
                    reasoner = reasoner.bindSchema(ModelFactory.createDefaultModel().read(new StringReader(tBoxFile), null, "TURTLE"));
                }
                catch (Exception e22) {
                    try {
                        reasoner = reasoner.bindSchema(ModelFactory.createDefaultModel().read(new StringReader(tBoxFile), null, "RDF/JSON"));
                    }
                    catch (Exception e3) {
                        this.logger.error(e2.getMessage(), e3);
                    }
                }
            }
        }
        this.addReasonerToReasonerMap(queryId, reasoner);
    }

    @Override
    public boolean getInferenceStatus() {
        return this.activateInference;
    }

    @Override
    public void parseSparqlQuery(SparqlQuery query2) throws ParseException {
        Query spQuery = QueryFactory.create(query2.getQueryCommand(), Syntax.syntaxSPARQL_11);
        for (String s : spQuery.getGraphURIs()) {
            if (this.jds.containsNamedModel(s)) continue;
            throw new ParseException("The model in the FROM clause is missing in the internal dataset, please put the static model in the dataset using putStaticNamedModel(String iri, String location) method of the engine.", 0);
        }
    }
}

