/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.sparql.jena.data_source;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import eu.larkc.csparql.common.RDFTable;
import eu.larkc.csparql.common.RDFTuple;
import eu.larkc.csparql.common.data_source.Datasource;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class JenaDatasource
implements Datasource {
    private Dataset dataSource = DatasetFactory.createMem();

    @Override
    public void putNamedModel(String namedModelURI, List<RDFTuple> modelContent) {
        Model m = ModelFactory.createDefaultModel();
        for (RDFTuple t : modelContent) {
            this.addStatement(t.get(0), t.get(1), t.get(2), m);
        }
        this.dataSource.addNamedModel(namedModelURI, m);
    }

    @Override
    public List<RDFTuple> getNamedModel(String namedModelURI) {
        Model m = this.dataSource.getNamedModel(namedModelURI);
        ArrayList<RDFTuple> list = new ArrayList<RDFTuple>();
        StmtIterator it = m.listStatements();
        while (it.hasNext()) {
            RDFTuple tuple = new RDFTuple();
            Statement stm = (Statement)it.next();
            tuple.addFields(this.formatSubject(stm.getSubject()), this.formatPredicate(stm.getPredicate()), this.format(stm.getObject()));
            list.add(tuple);
        }
        return list;
    }

    @Override
    public void execUpdateQuery(String queryBody) {
        UpdateRequest updateRequest = UpdateFactory.create(queryBody, Syntax.syntaxSPARQL_11);
        UpdateAction.execute(updateRequest, this.dataSource);
    }

    @Override
    public boolean containsNamedModel(String namedModelURI) {
        return this.dataSource.containsNamedModel(namedModelURI);
    }

    @Override
    public RDFTable evaluateGeneralQuery(String queryBody) {
        Query query2 = QueryFactory.create(queryBody, Syntax.syntaxSPARQL_11);
        QueryExecution qexec = QueryExecutionFactory.create(query2, this.dataSource);
        RDFTable table = null;
        if (query2.isAskType()) {
            table = new RDFTable("Answer");
            RDFTuple tuple = new RDFTuple();
            tuple.addFields("" + qexec.execAsk());
            table.add(tuple);
        } else if (query2.isConstructType() || query2.isDescribeType()) {
            Model m = null;
            m = query2.isDescribeType() ? qexec.execDescribe() : qexec.execConstruct();
            table = new RDFTable("Subject", "Predicate", "Object");
            StringWriter w = new StringWriter();
            m.write(w, "RDF/JSON");
            table.setJsonSerialization(w.toString());
            StmtIterator it = m.listStatements();
            while (it.hasNext()) {
                RDFTuple tuple = new RDFTuple();
                Statement stm = (Statement)it.next();
                tuple.addFields(this.formatSubject(stm.getSubject()), this.formatPredicate(stm.getPredicate()), this.format(stm.getObject()));
                table.add(tuple);
            }
        } else {
            ResultSet resultSet = qexec.execSelect();
            table = new RDFTable(resultSet.getResultVars());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ResultSetRewindable tempResultSet = ResultSetFactory.makeRewindable(resultSet);
            ResultSetFormatter.outputAsJSON((OutputStream)bos, tempResultSet);
            table.setJsonSerialization(bos.toString());
            tempResultSet.reset();
            while (tempResultSet.hasNext()) {
                RDFTuple tuple = new RDFTuple();
                QuerySolution soln = tempResultSet.nextSolution();
                for (String s : table.getNames()) {
                    RDFNode n = soln.get(s);
                    if (n == null) {
                        tuple.addFields("");
                        continue;
                    }
                    tuple.addFields(this.format(n));
                }
                table.add(tuple);
            }
        }
        return table;
    }

    @Override
    public void removeNamedModel(String namedModelURI) {
        this.dataSource.removeNamedModel(namedModelURI);
    }

    public Dataset getDatasource() {
        return this.dataSource;
    }

    private void addStatement(String subject, String predicate, String object, Model model) {
        StatementImpl s;
        String[] objectParts = object.split("\\^\\^");
        if (objectParts.length > 1) {
            TypeMapper tm = TypeMapper.getInstance();
            RDFDatatype d = tm.getTypeByName(objectParts[1]);
            Literal lObject = model.createTypedLiteral(objectParts[0].replaceAll("\"", ""), d);
            s = new StatementImpl(new ResourceImpl(subject), new PropertyImpl(predicate), lObject);
        } else {
            s = new StatementImpl(new ResourceImpl(subject), new PropertyImpl(predicate), new ResourceImpl(object));
        }
        model.add(s);
    }

    private String format(RDFNode n) {
        if (n.isLiteral()) {
            return "\"" + n.asLiteral().getLexicalForm() + "\"^^" + n.asLiteral().getDatatypeURI();
        }
        return n.toString();
    }

    private String formatPredicate(Property predicate) {
        return predicate.toString();
    }

    private String formatSubject(Resource subject) {
        return subject.toString();
    }
}

