/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.sparql.sesame;

import eu.larkc.csparql.common.RDFTable;
import eu.larkc.csparql.common.RDFTuple;
import eu.larkc.csparql.common.data_source.Datasource;
import eu.larkc.csparql.common.utils.ReasonerChainingType;
import eu.larkc.csparql.sparql.api.SparqlEngine;
import eu.larkc.csparql.sparql.api.SparqlQuery;
import java.util.ArrayList;
import java.util.HashMap;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;
import org.openrdf.sail.memory.model.MemURI;

public class SesameEngine
implements SparqlEngine {
    private SailRepository repository = null;
    private RepositoryConnection connection = null;
    private HashMap<String, Query> queries = null;

    @Override
    public void destroy() {
        if (this.repository == null) {
            return;
        }
        try {
            this.repository.shutDown();
        }
        catch (RepositoryException e2) {
            e2.printStackTrace();
        }
        this.repository = null;
    }

    public GraphQueryResult evaluateGraphQuery(String query2) {
        GraphQuery q = null;
        q = (GraphQuery)this.createOrGetQuery(query2);
        GraphQueryResult r = null;
        try {
            if (q != null) {
                r = q.evaluate();
                return r;
            }
        }
        catch (QueryEvaluationException e2) {
            e2.printStackTrace();
        }
        return null;
    }

    @Override
    public RDFTable evaluateQuery(SparqlQuery query2) {
        Query q = null;
        q = this.createOrGetQuery(query2.getQueryCommand());
        try {
            if (q != null) {
                if (q instanceof TupleQuery) {
                    TupleQuery tq = (TupleQuery)q;
                    TupleQueryResult tqr = tq.evaluate();
                    RDFTable table = new RDFTable(tqr.getBindingNames());
                    while (tqr.hasNext()) {
                        RDFTuple t = new RDFTuple();
                        BindingSet s = (BindingSet)tqr.next();
                        for (String n : tqr.getBindingNames()) {
                            t.addFields(s.getBinding(n).getValue().stringValue());
                        }
                        table.add(t);
                    }
                    return table;
                }
                if (q instanceof GraphQuery) {
                    ArrayList<String> names = new ArrayList<String>();
                    names.add("Subject");
                    names.add("Predicate");
                    names.add("Object");
                    GraphQuery gq = (GraphQuery)q;
                    GraphQueryResult gqr = gq.evaluate();
                    RDFTable table = new RDFTable(names);
                    while (gqr.hasNext()) {
                        RDFTuple t = new RDFTuple();
                        Statement s = (Statement)gqr.next();
                        t.addFields(s.getSubject().stringValue(), s.getPredicate().stringValue(), s.getObject().stringValue());
                        table.add(t);
                    }
                    return table;
                }
                return null;
            }
        }
        catch (QueryEvaluationException e2) {
            e2.printStackTrace();
        }
        return null;
    }

    private Query createOrGetQuery(String query2) {
        if (!this.queries.containsKey(query2)) {
            try {
                this.queries.put(query2, (Query)this.connection.prepareTupleQuery(QueryLanguage.SPARQL, query2));
            }
            catch (RepositoryException e2) {
                e2.printStackTrace();
            }
            catch (MalformedQueryException e3) {
                e3.printStackTrace();
            }
        }
        return this.queries.get(query2);
    }

    @Override
    public void addStatement(String subject, String predicate, String object) {
        Statement s = this.createStatement(subject, predicate, object);
        try {
            this.connection.add(s, new Resource[]{null});
        }
        catch (RepositoryException e2) {
            e2.printStackTrace();
        }
    }

    private Statement createStatement(String subject, String predicate, String object) {
        MemURI s = new MemURI((Object)"this", "", subject);
        MemURI p = new MemURI((Object)"this", "", predicate);
        MemURI o = new MemURI((Object)"this", "", object);
        return new StatementImpl((Resource)s, (URI)p, (Value)o);
    }

    public void addStatement(String subject, String predicate, String object, String timestamp2) {
    }

    @Override
    public void initialize() {
        if (this.repository != null) {
            return;
        }
        this.queries = new HashMap();
        this.repository = new SailRepository((Sail)new MemoryStore());
        try {
            this.repository.initialize();
            this.connection = this.repository.getConnection();
        }
        catch (RepositoryException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void clean() {
        try {
            this.connection.close();
            this.repository = null;
        }
        catch (RepositoryException e2) {
            e2.printStackTrace();
        }
        this.initialize();
    }

    public void cleanWtf() {
        try {
            this.connection.clear(new Resource[]{null});
        }
        catch (RepositoryException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void addStatement(String subject, String predicate, String object, long timestamp2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getEngineType() {
        return "sesame";
    }

    @Override
    public void execUpdateQueryOverDatasource(String queryBody) {
    }

    @Override
    public RDFTable evaluateGeneralQueryOverDatasource(String queryBody) {
        return null;
    }

    @Override
    public void parseSparqlQuery(SparqlQuery query2) {
    }

    @Override
    public void putStaticNamedModel(String iri2, String location) {
    }

    @Override
    public void removeStaticNamedModel(String iri2) {
    }

    @Override
    public Datasource getDataSource() {
        return null;
    }

    @Override
    public boolean getInferenceStatus() {
        return false;
    }

    @Override
    public void setReasonerMap(Object reasonerMap) {
    }

    @Override
    public void arrestInference(String queryId) {
    }

    @Override
    public void addReasonerToReasonerMap(String queryId, Object reasoner) {
    }

    @Override
    public void restartInference(String queryId) {
    }

    @Override
    public void updateReasoner(String queryId) {
    }

    @Override
    public void updateReasoner(String queryId, String rulesFile, ReasonerChainingType chainingType) {
    }

    @Override
    public void updateReasoner(String queryId, String rulesFile, ReasonerChainingType chainingType, String tBoxFile) {
    }
}

