/*
 * Decompiled with CFR 0.152.
 */
package gflima;

import eu.larkc.csparql.cep.api.RdfQuadruple;
import eu.larkc.csparql.cep.api.RdfStream;
import eu.larkc.csparql.core.engine.ConsoleFormatter;
import eu.larkc.csparql.core.engine.CsparqlEngineImpl;
import eu.larkc.csparql.core.engine.CsparqlQueryResultProxy;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.log4j.PropertyConfigurator;

public class App {
    private static final String PROGNAME = "csparql-cli";
    private static boolean optVerbose = false;

    private static void trace(String msg) {
        if (optVerbose) {
            System.err.println("trace: " + msg);
        }
    }

    private static void error(String msg) {
        System.err.println("error: " + msg);
        System.exit(1);
    }

    private static void usage(String msg) {
        System.err.println(String.format("%s: %s", PROGNAME, msg));
        System.err.println(String.format("Try '%s --help' for more information.", PROGNAME));
        System.exit(1);
    }

    private static String readFileAsString(String path) {
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
            return new String(encoded, StandardCharsets.UTF_8);
        }
        catch (IOException e2) {
            App.error(String.format("cannot access '%s'", path));
            assert (false);
            return null;
        }
    }

    private static BufferedReader readFileAsStream(String path) {
        try {
            if (path == "-") {
                return new BufferedReader(new InputStreamReader(System.in));
            }
            return new BufferedReader(new FileReader(path));
        }
        catch (FileNotFoundException e2) {
            App.error(String.format("cannot access '%s'", path));
            assert (false);
            return null;
        }
    }

    private static long parseTime(String str2) {
        String[] toks = str2.split(":");
        if (toks.length == 1) {
            return Long.parseLong(toks[0]);
        }
        if (toks.length == 3) {
            long h = Long.parseLong(toks[0]);
            long m = Long.parseLong(toks[1]);
            long s = Long.parseLong(toks[2]);
            h = h > 0L ? h : 0L;
            m = m > 0L ? m : 0L;
            s = s > 0L ? s : 0L;
            return (h * 3600L + m * 60L + s * 1L) * 1000L;
        }
        return -1L;
    }

    public static void main(String[] args) {
        String iri2;
        PropertyConfigurator.configure("etc/log4j.properties");
        OptionParser parser = new OptionParser();
        parser.accepts("help");
        parser.accepts("static").withRequiredArg();
        parser.accepts("stream-iri").withRequiredArg();
        parser.accepts("verbose");
        OptionSet opts = null;
        try {
            opts = parser.parse(args);
        }
        catch (OptionException e2) {
            App.usage(e2.getMessage());
        }
        if (opts.has("help")) {
            System.out.print("Usage: csparql-cli [OPTION]... QUERY STREAM\nApply QUERY to STREAM.\n\nWith no STREAM, or if STREAM is -, read standard input.\n\n      --static=IRI      static model IRI\n      --stream-iri=IRI  stream IRI\n      --verbose         explain what is being done\n      --help            display this help and exit\n");
            System.exit(0);
        }
        if (opts.has("verbose")) {
            optVerbose = true;
        }
        String pathToQuery = null;
        String pathToInput = "-";
        List<?> ell = opts.nonOptionArguments();
        if (ell.size() == 0) {
            App.usage("missing query operand");
        }
        if (ell.size() > 2) {
            App.usage("too many operands");
        }
        pathToQuery = (String)ell.get(0);
        if (ell.size() == 2) {
            pathToInput = (String)ell.get(1);
        }
        String query2 = App.readFileAsString(pathToQuery);
        BufferedReader input = App.readFileAsStream(pathToInput);
        CsparqlEngineImpl engine = new CsparqlEngineImpl();
        engine.initialize();
        if (opts.hasArgument("static")) {
            iri2 = (String)opts.valueOf("static");
            assert (iri2 != null);
            App.trace("--static: " + iri2);
            try {
                engine.putStaticNamedModel(iri2, iri2);
            }
            catch (Exception e3) {
                App.error("bad static model: " + iri2);
            }
        }
        iri2 = opts.hasArgument("stream-iri") ? (String)opts.valueOf("stream-iri") : "";
        RdfStream stream = new RdfStream(iri2);
        engine.registerStream(stream);
        CsparqlQueryResultProxy result = null;
        try {
            result = engine.registerQuery(query2, false);
        }
        catch (Exception e4) {
            App.error("bad query: " + e4.getMessage());
        }
        assert (result != null);
        result.addObserver(new ConsoleFormatter());
        try {
            String line;
            while ((line = input.readLine()) != null) {
                long time;
                String[] toks = line.split(" +");
                if (toks.length != 4) {
                    App.error("bad line: " + line);
                }
                if ((time = App.parseTime(toks[3])) < 0L) {
                    App.error("bad time value: " + toks[3]);
                }
                RdfQuadruple q = new RdfQuadruple(toks[0], toks[1], toks[2], App.parseTime(toks[3]));
                stream.put(q);
                App.trace(q.toString());
            }
        }
        catch (IOException e5) {
            App.error("read error: " + e5.getMessage());
        }
        engine.unregisterQuery(result.getId());
        engine.unregisterStream(stream.getIRI());
        System.exit(0);
    }
}

