/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.process.normalize;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import org.apache.jena.riot.process.normalize.DatatypeHandler;

class NormalizeValue2 {
    static char NonChar = '\u0000';
    static char CH_ZERO = (char)48;
    static DatatypeHandler dtInteger = new DatatypeHandler(){

        @Override
        public Node handle(Node node, String lexicalForm, RDFDatatype datatype) {
            char[] chars = lexicalForm.toCharArray();
            if (chars.length == 0) {
                return node;
            }
            NormalizeValue2.stripLeadingPlus(chars);
            NormalizeValue2.stripLeadingZeros(chars);
            String lex2 = NormalizeValue2.rebuild(chars);
            if (lex2 == null) {
                return node;
            }
            return NodeFactory.createLiteral(lex2, datatype);
        }
    };
    static DatatypeHandler dtDecimal = new DatatypeHandler(){

        @Override
        public Node handle(Node node, String lexicalForm, RDFDatatype datatype) {
            char[] chars = lexicalForm.toCharArray();
            if (chars.length == 0) {
                return node;
            }
            NormalizeValue2.stripLeadingPlus(chars);
            NormalizeValue2.stripLeadingZeros(chars);
            NormalizeValue2.stripTrailingZeros(chars);
            String lex2 = NormalizeValue2.rebuild(chars);
            if (lex2 == null) {
                return node;
            }
            return NodeFactory.createLiteral(lex2, datatype);
        }
    };

    NormalizeValue2() {
    }

    private static void stripLeadingPlus(char[] chars) {
        if (chars[0] == '+') {
            chars[0] = NonChar;
        }
    }

    private static void stripLeadingZeros(char[] chars) {
        int idx = 0;
        if (chars[0] == '-' || chars[0] == NonChar) {
            idx = 1;
        }
        while (idx < chars.length && chars[idx] == CH_ZERO) {
            chars[idx] = NonChar;
            ++idx;
        }
        if (idx == chars.length || chars[idx] == '.') {
            chars[idx - 1] = CH_ZERO;
        }
    }

    private static void stripTrailingZeros(char[] chars) {
        int idx;
        int iDot;
        for (iDot = 0; iDot < chars.length && chars[iDot] != '.'; ++iDot) {
        }
        if (iDot == chars.length) {
            // empty if block
        }
        int start = 0;
        if (chars[0] == '-' || chars[0] == NonChar) {
            start = 1;
        }
        for (idx = chars.length - 1; idx >= start && chars[idx] == CH_ZERO; --idx) {
            chars[idx] = NonChar;
        }
        if (idx == start || chars[idx] == '.') {
            chars[idx - 1] = CH_ZERO;
        }
    }

    private static String rebuild(char[] chars) {
        boolean modified = false;
        int j = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == NonChar) {
                modified = true;
                continue;
            }
            if (!modified) continue;
            chars[j] = chars[i];
            ++j;
        }
        if (!modified) {
            return null;
        }
        return new String(chars, 0, j);
    }
}

