/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.protocol;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Stack;
import org.apache.thrift.TByteArrayOutputStream;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBase64Utils;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TTransport;

public class TJSONProtocol
extends TProtocol {
    private static final byte[] COMMA = new byte[]{44};
    private static final byte[] COLON = new byte[]{58};
    private static final byte[] LBRACE = new byte[]{123};
    private static final byte[] RBRACE = new byte[]{125};
    private static final byte[] LBRACKET = new byte[]{91};
    private static final byte[] RBRACKET = new byte[]{93};
    private static final byte[] QUOTE = new byte[]{34};
    private static final byte[] BACKSLASH = new byte[]{92};
    private static final byte[] ZERO = new byte[]{48};
    private static final byte[] ESCSEQ = new byte[]{92, 117, 48, 48};
    private static final long VERSION = 1L;
    private static final byte[] JSON_CHAR_TABLE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 98, 116, 110, 0, 102, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 34, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final String ESCAPE_CHARS = "\"\\/bfnrt";
    private static final byte[] ESCAPE_CHAR_VALS = new byte[]{34, 92, 47, 8, 12, 10, 13, 9};
    private static final int DEF_STRING_SIZE = 16;
    private static final byte[] NAME_BOOL = new byte[]{116, 102};
    private static final byte[] NAME_BYTE = new byte[]{105, 56};
    private static final byte[] NAME_I16 = new byte[]{105, 49, 54};
    private static final byte[] NAME_I32 = new byte[]{105, 51, 50};
    private static final byte[] NAME_I64 = new byte[]{105, 54, 52};
    private static final byte[] NAME_DOUBLE = new byte[]{100, 98, 108};
    private static final byte[] NAME_STRUCT = new byte[]{114, 101, 99};
    private static final byte[] NAME_STRING = new byte[]{115, 116, 114};
    private static final byte[] NAME_MAP = new byte[]{109, 97, 112};
    private static final byte[] NAME_LIST = new byte[]{108, 115, 116};
    private static final byte[] NAME_SET = new byte[]{115, 101, 116};
    private static final TStruct ANONYMOUS_STRUCT = new TStruct();
    private Stack<JSONBaseContext> contextStack_ = new Stack();
    private JSONBaseContext context_ = new JSONBaseContext();
    private LookaheadReader reader_ = new LookaheadReader();
    private boolean fieldNamesAsString_ = false;
    private byte[] tmpbuf_ = new byte[4];

    private static final byte[] getTypeNameForTypeID(byte typeID) throws TException {
        switch (typeID) {
            case 2: {
                return NAME_BOOL;
            }
            case 3: {
                return NAME_BYTE;
            }
            case 6: {
                return NAME_I16;
            }
            case 8: {
                return NAME_I32;
            }
            case 10: {
                return NAME_I64;
            }
            case 4: {
                return NAME_DOUBLE;
            }
            case 11: {
                return NAME_STRING;
            }
            case 12: {
                return NAME_STRUCT;
            }
            case 13: {
                return NAME_MAP;
            }
            case 14: {
                return NAME_SET;
            }
            case 15: {
                return NAME_LIST;
            }
        }
        throw new TProtocolException(5, "Unrecognized type");
    }

    private static final byte getTypeIDForTypeName(byte[] name) throws TException {
        int result = 0;
        if (name.length > 1) {
            switch (name[0]) {
                case 100: {
                    result = 4;
                    break;
                }
                case 105: {
                    switch (name[1]) {
                        case 56: {
                            result = 3;
                            break;
                        }
                        case 49: {
                            result = 6;
                            break;
                        }
                        case 51: {
                            result = 8;
                            break;
                        }
                        case 54: {
                            result = 10;
                        }
                    }
                    break;
                }
                case 108: {
                    result = 15;
                    break;
                }
                case 109: {
                    result = 13;
                    break;
                }
                case 114: {
                    result = 12;
                    break;
                }
                case 115: {
                    if (name[1] == 116) {
                        result = 11;
                        break;
                    }
                    if (name[1] != 101) break;
                    result = 14;
                    break;
                }
                case 116: {
                    result = 2;
                }
            }
        }
        if (result == 0) {
            throw new TProtocolException(5, "Unrecognized type");
        }
        return (byte)result;
    }

    private void pushContext(JSONBaseContext c) {
        this.contextStack_.push(this.context_);
        this.context_ = c;
    }

    private void popContext() {
        this.context_ = this.contextStack_.pop();
    }

    public TJSONProtocol(TTransport trans) {
        super(trans);
    }

    public TJSONProtocol(TTransport trans, boolean fieldNamesAsString) {
        super(trans);
        this.fieldNamesAsString_ = fieldNamesAsString;
    }

    public void reset() {
        this.contextStack_.clear();
        this.context_ = new JSONBaseContext();
        this.reader_ = new LookaheadReader();
    }

    protected void readJSONSyntaxChar(byte[] b) throws TException {
        byte ch = this.reader_.read();
        if (ch != b[0]) {
            throw new TProtocolException(1, "Unexpected character:" + (char)ch);
        }
    }

    private static final byte hexVal(byte ch) throws TException {
        if (ch >= 48 && ch <= 57) {
            return (byte)((char)ch - 48);
        }
        if (ch >= 97 && ch <= 102) {
            return (byte)((char)ch - 97 + 10);
        }
        throw new TProtocolException(1, "Expected hex character");
    }

    private static final byte hexChar(byte val) {
        if ((val = (byte)(val & 0xF)) < 10) {
            return (byte)((char)val + 48);
        }
        return (byte)((char)(val - 10) + 97);
    }

    private void writeJSONString(byte[] b) throws TException {
        this.context_.write();
        this.trans_.write(QUOTE);
        int len = b.length;
        for (int i = 0; i < len; ++i) {
            if ((b[i] & 0xFF) >= 48) {
                if (b[i] == BACKSLASH[0]) {
                    this.trans_.write(BACKSLASH);
                    this.trans_.write(BACKSLASH);
                    continue;
                }
                this.trans_.write(b, i, 1);
                continue;
            }
            this.tmpbuf_[0] = JSON_CHAR_TABLE[b[i]];
            if (this.tmpbuf_[0] == 1) {
                this.trans_.write(b, i, 1);
                continue;
            }
            if (this.tmpbuf_[0] > 1) {
                this.trans_.write(BACKSLASH);
                this.trans_.write(this.tmpbuf_, 0, 1);
                continue;
            }
            this.trans_.write(ESCSEQ);
            this.tmpbuf_[0] = TJSONProtocol.hexChar((byte)(b[i] >> 4));
            this.tmpbuf_[1] = TJSONProtocol.hexChar(b[i]);
            this.trans_.write(this.tmpbuf_, 0, 2);
        }
        this.trans_.write(QUOTE);
    }

    private void writeJSONInteger(long num) throws TException {
        this.context_.write();
        String str2 = Long.toString(num);
        boolean escapeNum = this.context_.escapeNum();
        if (escapeNum) {
            this.trans_.write(QUOTE);
        }
        try {
            byte[] buf = str2.getBytes("UTF-8");
            this.trans_.write(buf);
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
        if (escapeNum) {
            this.trans_.write(QUOTE);
        }
    }

    private void writeJSONDouble(double num) throws TException {
        boolean escapeNum;
        this.context_.write();
        String str2 = Double.toString(num);
        boolean special = false;
        switch (str2.charAt(0)) {
            case 'I': 
            case 'N': {
                special = true;
                break;
            }
            case '-': {
                if (str2.charAt(1) != 'I') break;
                special = true;
                break;
            }
        }
        boolean bl = escapeNum = special || this.context_.escapeNum();
        if (escapeNum) {
            this.trans_.write(QUOTE);
        }
        try {
            byte[] b = str2.getBytes("UTF-8");
            this.trans_.write(b, 0, b.length);
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
        if (escapeNum) {
            this.trans_.write(QUOTE);
        }
    }

    private void writeJSONBase64(byte[] b, int offset, int length) throws TException {
        int len;
        this.context_.write();
        this.trans_.write(QUOTE);
        int off = offset;
        for (len = length; len >= 3; len -= 3) {
            TBase64Utils.encode(b, off, 3, this.tmpbuf_, 0);
            this.trans_.write(this.tmpbuf_, 0, 4);
            off += 3;
        }
        if (len > 0) {
            TBase64Utils.encode(b, off, len, this.tmpbuf_, 0);
            this.trans_.write(this.tmpbuf_, 0, len + 1);
        }
        this.trans_.write(QUOTE);
    }

    private void writeJSONObjectStart() throws TException {
        this.context_.write();
        this.trans_.write(LBRACE);
        this.pushContext(new JSONPairContext());
    }

    private void writeJSONObjectEnd() throws TException {
        this.popContext();
        this.trans_.write(RBRACE);
    }

    private void writeJSONArrayStart() throws TException {
        this.context_.write();
        this.trans_.write(LBRACKET);
        this.pushContext(new JSONListContext());
    }

    private void writeJSONArrayEnd() throws TException {
        this.popContext();
        this.trans_.write(RBRACKET);
    }

    public void writeMessageBegin(TMessage message) throws TException {
        this.writeJSONArrayStart();
        this.writeJSONInteger(1L);
        try {
            byte[] b = message.name.getBytes("UTF-8");
            this.writeJSONString(b);
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
        this.writeJSONInteger(message.type);
        this.writeJSONInteger(message.seqid);
    }

    public void writeMessageEnd() throws TException {
        this.writeJSONArrayEnd();
    }

    public void writeStructBegin(TStruct struct) throws TException {
        this.writeJSONObjectStart();
    }

    public void writeStructEnd() throws TException {
        this.writeJSONObjectEnd();
    }

    public void writeFieldBegin(TField field) throws TException {
        if (this.fieldNamesAsString_) {
            this.writeString(field.name);
        } else {
            this.writeJSONInteger(field.id);
        }
        this.writeJSONObjectStart();
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(field.type));
    }

    public void writeFieldEnd() throws TException {
        this.writeJSONObjectEnd();
    }

    public void writeFieldStop() {
    }

    public void writeMapBegin(TMap map) throws TException {
        this.writeJSONArrayStart();
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(map.keyType));
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(map.valueType));
        this.writeJSONInteger(map.size);
        this.writeJSONObjectStart();
    }

    public void writeMapEnd() throws TException {
        this.writeJSONObjectEnd();
        this.writeJSONArrayEnd();
    }

    public void writeListBegin(TList list) throws TException {
        this.writeJSONArrayStart();
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(list.elemType));
        this.writeJSONInteger(list.size);
    }

    public void writeListEnd() throws TException {
        this.writeJSONArrayEnd();
    }

    public void writeSetBegin(TSet set) throws TException {
        this.writeJSONArrayStart();
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(set.elemType));
        this.writeJSONInteger(set.size);
    }

    public void writeSetEnd() throws TException {
        this.writeJSONArrayEnd();
    }

    public void writeBool(boolean b) throws TException {
        this.writeJSONInteger(b ? 1L : 0L);
    }

    public void writeByte(byte b) throws TException {
        this.writeJSONInteger(b);
    }

    public void writeI16(short i16) throws TException {
        this.writeJSONInteger(i16);
    }

    public void writeI32(int i32) throws TException {
        this.writeJSONInteger(i32);
    }

    public void writeI64(long i64) throws TException {
        this.writeJSONInteger(i64);
    }

    public void writeDouble(double dub) throws TException {
        this.writeJSONDouble(dub);
    }

    public void writeString(String str2) throws TException {
        try {
            byte[] b = str2.getBytes("UTF-8");
            this.writeJSONString(b);
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
    }

    public void writeBinary(ByteBuffer bin) throws TException {
        this.writeJSONBase64(bin.array(), bin.position() + bin.arrayOffset(), bin.limit() - bin.position() - bin.arrayOffset());
    }

    private TByteArrayOutputStream readJSONString(boolean skipContext) throws TException {
        byte ch;
        TByteArrayOutputStream arr = new TByteArrayOutputStream(16);
        if (!skipContext) {
            this.context_.read();
        }
        this.readJSONSyntaxChar(QUOTE);
        while ((ch = this.reader_.read()) != QUOTE[0]) {
            if (ch == ESCSEQ[0]) {
                ch = this.reader_.read();
                if (ch == ESCSEQ[1]) {
                    this.readJSONSyntaxChar(ZERO);
                    this.readJSONSyntaxChar(ZERO);
                    this.trans_.readAll(this.tmpbuf_, 0, 2);
                    ch = (byte)((TJSONProtocol.hexVal(this.tmpbuf_[0]) << 4) + TJSONProtocol.hexVal(this.tmpbuf_[1]));
                } else {
                    int off = ESCAPE_CHARS.indexOf(ch);
                    if (off == -1) {
                        throw new TProtocolException(1, "Expected control char");
                    }
                    ch = ESCAPE_CHAR_VALS[off];
                }
            }
            arr.write(ch);
        }
        return arr;
    }

    private boolean isJSONNumeric(byte b) {
        switch (b) {
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 69: 
            case 101: {
                return true;
            }
        }
        return false;
    }

    private String readJSONNumericChars() throws TException {
        byte ch;
        StringBuilder strbld = new StringBuilder();
        while (this.isJSONNumeric(ch = this.reader_.peek())) {
            strbld.append((char)this.reader_.read());
        }
        return strbld.toString();
    }

    private long readJSONInteger() throws TException {
        this.context_.read();
        if (this.context_.escapeNum()) {
            this.readJSONSyntaxChar(QUOTE);
        }
        String str2 = this.readJSONNumericChars();
        if (this.context_.escapeNum()) {
            this.readJSONSyntaxChar(QUOTE);
        }
        try {
            return Long.valueOf(str2);
        }
        catch (NumberFormatException ex) {
            throw new TProtocolException(1, "Bad data encounted in numeric data");
        }
    }

    private double readJSONDouble() throws TException {
        this.context_.read();
        if (this.reader_.peek() == QUOTE[0]) {
            TByteArrayOutputStream arr = this.readJSONString(true);
            try {
                double dub = Double.valueOf(arr.toString("UTF-8"));
                if (!(this.context_.escapeNum() || Double.isNaN(dub) || Double.isInfinite(dub))) {
                    throw new TProtocolException(1, "Numeric data unexpectedly quoted");
                }
                return dub;
            }
            catch (UnsupportedEncodingException ex) {
                throw new TException("JVM DOES NOT SUPPORT UTF-8");
            }
        }
        if (this.context_.escapeNum()) {
            this.readJSONSyntaxChar(QUOTE);
        }
        try {
            return Double.valueOf(this.readJSONNumericChars());
        }
        catch (NumberFormatException ex) {
            throw new TProtocolException(1, "Bad data encounted in numeric data");
        }
    }

    private byte[] readJSONBase64() throws TException {
        TByteArrayOutputStream arr = this.readJSONString(false);
        byte[] b = arr.get();
        int len = arr.len();
        int off = 0;
        int size = 0;
        while (len >= 4) {
            TBase64Utils.decode(b, off, 4, b, size);
            off += 4;
            len -= 4;
            size += 3;
        }
        if (len > 1) {
            TBase64Utils.decode(b, off, len, b, size);
            size += len - 1;
        }
        byte[] result = new byte[size];
        System.arraycopy(b, 0, result, 0, size);
        return result;
    }

    private void readJSONObjectStart() throws TException {
        this.context_.read();
        this.readJSONSyntaxChar(LBRACE);
        this.pushContext(new JSONPairContext());
    }

    private void readJSONObjectEnd() throws TException {
        this.readJSONSyntaxChar(RBRACE);
        this.popContext();
    }

    private void readJSONArrayStart() throws TException {
        this.context_.read();
        this.readJSONSyntaxChar(LBRACKET);
        this.pushContext(new JSONListContext());
    }

    private void readJSONArrayEnd() throws TException {
        this.readJSONSyntaxChar(RBRACKET);
        this.popContext();
    }

    public TMessage readMessageBegin() throws TException {
        String name;
        this.readJSONArrayStart();
        if (this.readJSONInteger() != 1L) {
            throw new TProtocolException(4, "Message contained bad version.");
        }
        try {
            name = this.readJSONString(false).toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
        byte type = (byte)this.readJSONInteger();
        int seqid = (int)this.readJSONInteger();
        return new TMessage(name, type, seqid);
    }

    public void readMessageEnd() throws TException {
        this.readJSONArrayEnd();
    }

    public TStruct readStructBegin() throws TException {
        this.readJSONObjectStart();
        return ANONYMOUS_STRUCT;
    }

    public void readStructEnd() throws TException {
        this.readJSONObjectEnd();
    }

    public TField readFieldBegin() throws TException {
        byte type;
        byte ch = this.reader_.peek();
        short id = 0;
        if (ch == RBRACE[0]) {
            type = 0;
        } else {
            id = (short)this.readJSONInteger();
            this.readJSONObjectStart();
            type = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        }
        return new TField("", type, id);
    }

    public void readFieldEnd() throws TException {
        this.readJSONObjectEnd();
    }

    public TMap readMapBegin() throws TException {
        this.readJSONArrayStart();
        byte keyType = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        byte valueType = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        int size = (int)this.readJSONInteger();
        this.readJSONObjectStart();
        return new TMap(keyType, valueType, size);
    }

    public void readMapEnd() throws TException {
        this.readJSONObjectEnd();
        this.readJSONArrayEnd();
    }

    public TList readListBegin() throws TException {
        this.readJSONArrayStart();
        byte elemType = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        int size = (int)this.readJSONInteger();
        return new TList(elemType, size);
    }

    public void readListEnd() throws TException {
        this.readJSONArrayEnd();
    }

    public TSet readSetBegin() throws TException {
        this.readJSONArrayStart();
        byte elemType = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        int size = (int)this.readJSONInteger();
        return new TSet(elemType, size);
    }

    public void readSetEnd() throws TException {
        this.readJSONArrayEnd();
    }

    public boolean readBool() throws TException {
        return this.readJSONInteger() != 0L;
    }

    public byte readByte() throws TException {
        return (byte)this.readJSONInteger();
    }

    public short readI16() throws TException {
        return (short)this.readJSONInteger();
    }

    public int readI32() throws TException {
        return (int)this.readJSONInteger();
    }

    public long readI64() throws TException {
        return this.readJSONInteger();
    }

    public double readDouble() throws TException {
        return this.readJSONDouble();
    }

    public String readString() throws TException {
        try {
            return this.readJSONString(false).toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
    }

    public ByteBuffer readBinary() throws TException {
        return ByteBuffer.wrap(this.readJSONBase64());
    }

    protected class LookaheadReader {
        private boolean hasData_;
        private byte[] data_ = new byte[1];

        protected LookaheadReader() {
        }

        protected byte read() throws TException {
            if (this.hasData_) {
                this.hasData_ = false;
            } else {
                TJSONProtocol.this.trans_.readAll(this.data_, 0, 1);
            }
            return this.data_[0];
        }

        protected byte peek() throws TException {
            if (!this.hasData_) {
                TJSONProtocol.this.trans_.readAll(this.data_, 0, 1);
            }
            this.hasData_ = true;
            return this.data_[0];
        }
    }

    protected class JSONPairContext
    extends JSONBaseContext {
        private boolean first_;
        private boolean colon_;

        protected JSONPairContext() {
            this.first_ = true;
            this.colon_ = true;
        }

        protected void write() throws TException {
            if (this.first_) {
                this.first_ = false;
                this.colon_ = true;
            } else {
                TJSONProtocol.this.trans_.write(this.colon_ ? COLON : COMMA);
                this.colon_ = !this.colon_;
            }
        }

        protected void read() throws TException {
            if (this.first_) {
                this.first_ = false;
                this.colon_ = true;
            } else {
                TJSONProtocol.this.readJSONSyntaxChar(this.colon_ ? COLON : COMMA);
                this.colon_ = !this.colon_;
            }
        }

        protected boolean escapeNum() {
            return this.colon_;
        }
    }

    protected class JSONListContext
    extends JSONBaseContext {
        private boolean first_;

        protected JSONListContext() {
            this.first_ = true;
        }

        protected void write() throws TException {
            if (this.first_) {
                this.first_ = false;
            } else {
                TJSONProtocol.this.trans_.write(COMMA);
            }
        }

        protected void read() throws TException {
            if (this.first_) {
                this.first_ = false;
            } else {
                TJSONProtocol.this.readJSONSyntaxChar(COMMA);
            }
        }
    }

    protected class JSONBaseContext {
        protected JSONBaseContext() {
        }

        protected void write() throws TException {
        }

        protected void read() throws TException {
        }

        protected boolean escapeNum() {
            return false;
        }
    }

    public static class Factory
    implements TProtocolFactory {
        protected boolean fieldNamesAsString_ = false;

        public Factory() {
        }

        public Factory(boolean fieldNamesAsString) {
            this.fieldNamesAsString_ = fieldNamesAsString;
        }

        public TProtocol getProtocol(TTransport trans) {
            return new TJSONProtocol(trans, this.fieldNamesAsString_);
        }
    }
}

