/******************************************************************************\
 * Technische Universitaet Darmstadt, Institut fuer Nachrichtentechnik
 * Copyright (c) 2001-2014
 *
 * Author(s):
 *  Volker Fischer, Oliver Haffenden
 *
 * Description: Null implementation of CPacketSocket. See PacketSocketNull.cpp
 *
 *
 ******************************************************************************
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
\******************************************************************************/

#ifndef PACKET_SOCKET_NULL_H_INCLUDED
#define PACKET_SOCKET_NULL_H_INCLUDED

#include "PacketInOut.h"

class CPacketSocketNull : public CPacketSocket
{

public:

    // Set the sink which will receive the packets
    virtual void SetPacketSink(CPacketSink *pSink);
    // Stop sending packets to the sink
    virtual void ResetPacketSink(void);

    // Send packet to the socket
    virtual void SendPacket(const vector<_BYTE>& vecbydata, uint32_t addr=0, uint16_t port=0);

    virtual void poll();

    _BOOLEAN SetDestination(const string&);
    _BOOLEAN SetOrigin(const string&);
    _BOOLEAN GetDestination(string&);
};

#endif
