/******************************************************************************\
 * British Broadcasting Corporation
 * Copyright (c) 2001-2014
 *
 * Author(s):
 *  Julian Cable
 *
 * Description:
 *  ETSI DAB/DRM Electronic Programme Guide XML Decompressor
 *
 *
 ******************************************************************************
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
\******************************************************************************/

#ifndef _EPGDEC_H
#define _EPGDEC_H
#include "../GlobalDefinitions.h"
#include <QDomDocument>
#include <vector>
using namespace std;

class tag_length_value
{
public:

    tag_length_value(const _BYTE* p);

    bool is_cdata() const {
        return tag == 1;
    }
    bool is_epg() const {
        return tag == 2;
    }
    bool is_service_information() const {
        return tag == 3;
    }
    bool is_string_token_table() const {
        return tag == 4;
    }
    bool is_default_id() const {
        return tag == 5;
    }
    bool is_child_element() const {
        return (5<tag) && (tag<0x80);
    }
    bool is_attribute() const {
        return tag>=0x80;
    }

    uint8_t tag;
    size_t length;
    _BYTE* value;
};

class CEPGDecoder
{
public:
    CEPGDecoder ():doc()
    {
    }
    void decode (const vector<_BYTE>&);

    QDomDocument doc;

};
#endif
