/******************************************************************************
Este arquivo eh parte da implementacao do ambiente declarativo do middleware
Ginga (Ginga-NCL).

Direitos Autorais Reservados (c) 1989-2007 PUC-Rio/Laboratorio TeleMidia

Este programa eh software livre; voce pode redistribui-lo e/ou modificah-lo sob
os termos da Licenca Publica Geral GNU versao 2 conforme publicada pela Free
Software Foundation.

Este programa eh distribuido na expectativa de que seja util, porem, SEM
NENHUMA GARANTIA; nem mesmo a garantia implicita de COMERCIABILIDADE OU
ADEQUACAO A UMA FINALIDADE ESPECIFICA. Consulte a Licenca Publica Geral do
GNU versao 2 para mais detalhes.

Voce deve ter recebido uma copia da Licenca Publica Geral do GNU versao 2 junto
com este programa; se nao, escreva para a Free Software Foundation, Inc., no
endereco 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.

Para maiores informacoes:
ncl @ telemidia.puc-rio.br
http://www.ncl.org.br
http://www.ginga.org.br
http://www.telemidia.puc-rio.br
******************************************************************************
This file is part of the declarative environment of middleware Ginga (Ginga-NCL)

Copyright: 1989-2007 PUC-RIO/LABORATORIO TELEMIDIA, All Rights Reserved.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License version 2 as published by
the Free Software Foundation.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License version 2 for more
details.

You should have received a copy of the GNU General Public License version 2
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

For further information contact:
ncl @ telemidia.puc-rio.br
http://www.ncl.org.br
http://www.ginga.org.br
http://www.telemidia.puc-rio.br
*******************************************************************************/

#ifndef TEXTPLAYER_H_
#define TEXTPLAYER_H_

#include "mb/interface/IWindow.h"
#include "mb/interface/IFontProvider.h"
#include "mb/ILocalScreenManager.h"
using namespace ::br::pucrio::telemidia::ginga::core::mb;

#include "util/functions.h"

#include "system/compat/SystemCompat.h"
using namespace ::br::pucrio::telemidia::ginga::core::system::compat;

#include "system/thread/Thread.h"

#include "AVPlayer.h"

#include <iostream>
#include <map>
#include <vector>
#include <string>
using namespace std;

namespace br {
namespace pucrio {
namespace telemidia {
namespace ginga {
namespace core {
namespace player {
	class TextPlayer : public Player {
		protected:
			int fontHeight;
			int currentLine;
			int currentColumn;
			int tabSize;
			int fontSize;
			IColor* fontColor;
			IColor* bgColor;
			string fontUri;
			short currentAlign;
			GingaProviderID font;

		public:
			TextPlayer(GingaScreenID screenId);
			virtual ~TextPlayer();

		private:
			void initializePlayer(GingaScreenID screenId);

		public:
			static int write(
					GingaScreenID screenId,
					GingaSurfaceID s,
					string text,
					short textAlign,
					string fontUri = "",
					int fontSize = 12, IColor* fontColor = NULL);

			virtual bool play(){return Player::play();};
			virtual void stop(){Player::stop();};
			virtual void abort(){Player::abort();};
			virtual void pause(){Player::pause();};
			virtual void resume(){Player::resume();};

			bool setFont(string someUri);
			void setFontSize(int size);
			int getFontSize();
			int getFontHeight();
			void setBgColor(int red, int green, int blue, int alpha=255);
			void setColor(int red, int green, int blue, int alpha=255);
			void setTabSize(int size);
			int getTabSize();
			void drawText(string text, short align);
			bool drawTextLn(string text, short align);
			void tab();
			bool breakLine();
			int getCurrentColumn();
			int getCurrentLine();

			virtual void setPropertyValue(string name, string value);
	};
}
}
}
}
}
}

#endif /*TEXTPLAYER_H_*/
