/******************************************************************************
Este arquivo eh parte da implementacao do ambiente declarativo do middleware
Ginga (Ginga-NCL).

Direitos Autorais Reservados (c) 1989-2007 PUC-Rio/Laboratorio TeleMidia

Este programa eh software livre; voce pode redistribui-lo e/ou modificah-lo sob
os termos da Licenca Publica Geral GNU versao 2 conforme publicada pela Free
Software Foundation.

Este programa eh distribuido na expectativa de que seja util, porem, SEM
NENHUMA GARANTIA; nem mesmo a garantia implicita de COMERCIABILIDADE OU
ADEQUACAO A UMA FINALIDADE ESPECIFICA. Consulte a Licenca Publica Geral do
GNU versao 2 para mais detalhes.

Voce deve ter recebido uma copia da Licenca Publica Geral do GNU versao 2 junto
com este programa; se nao, escreva para a Free Software Foundation, Inc., no
endereco 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.

Para maiores informacoes:
ncl @ telemidia.puc-rio.br
http://www.ncl.org.br
http://www.ginga.org.br
http://www.telemidia.puc-rio.br
******************************************************************************
This file is part of the declarative environment of middleware Ginga (Ginga-NCL)

Copyright: 1989-2007 PUC-RIO/LABORATORIO TELEMIDIA, All Rights Reserved.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License version 2 as published by
the Free Software Foundation.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License version 2 for more
details.

You should have received a copy of the GNU General Public License version 2
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

For further information contact:
ncl @ telemidia.puc-rio.br
http://www.ncl.org.br
http://www.ginga.org.br
http://www.telemidia.puc-rio.br
*******************************************************************************/

#ifndef __THREAD_H__
#define __THREAD_H__

#include "system/compat/SystemCompat.h"
using namespace ::br::pucrio::telemidia::ginga::core::system::compat;

#include <errno.h>
#include <pthread.h>

namespace br {
namespace pucrio {
namespace telemidia {
namespace ginga {
namespace core {
namespace system {
namespace thread {
  class Thread {
	protected:
		bool isDeleting;

		pthread_mutex_t threadMutex;

		bool isThreadSleeping;
		pthread_mutex_t threadFlagMutex;
		pthread_cond_t threadFlagConditionVariable;

		bool isWaiting;
		pthread_mutex_t threadFlagMutexLockUntilSignal;
		pthread_cond_t threadFlagCVLockUntilSignal;

	private:
		pthread_mutex_t threadIdMutex;

		pthread_attr_t tattr;

	protected:
		virtual void run()=0;

	private:
		pthread_t threadId_;
		static void* function(void* ptr);

	public:
		Thread();
		virtual ~Thread();
		virtual void startThread();
		bool sleep(long int seconds);
		bool mSleep(long int milliseconds);
		bool wakeUp();
		void lock();
		void unlock();
		void waitForUnlockCondition();
		bool unlockConditionSatisfied();

		/* Mutex functions*/
		static void mutexInit(pthread_mutex_t* mutex, bool recursive=false);
		static void mutexDestroy(pthread_mutex_t* mutex);
		static void mutexLock(pthread_mutex_t* mutex);
		static void mutexUnlock(pthread_mutex_t* mutex);

		/* Cond functions */
		static void condInit(
				pthread_cond_t* cond, const pthread_condattr_t * attr);

		static void condDestroy(pthread_cond_t* cond);
		static void condWait(pthread_cond_t* cond, pthread_mutex_t* mutex);
		static void condSignal(pthread_cond_t* cond);

		/* Create functions */
		static void startNewThread(void* (*funcion) (void*), void* ptr);
  };
}
}
}
}
}
}
}

#endif //__THREAD_H__
