/******************************************************************************
Este arquivo eh parte da implementacao do ambiente declarativo do middleware
Ginga (Ginga-NCL).

Direitos Autorais Reservados (c) 1989-2007 PUC-Rio/Laboratorio TeleMidia

Este programa eh software livre; voce pode redistribui-lo e/ou modificah-lo sob
os termos da Licenca Publica Geral GNU versao 2 conforme publicada pela Free
Software Foundation.

Este programa eh distribuido na expectativa de que seja util, porem, SEM
NENHUMA GARANTIA; nem mesmo a garantia implicita de COMERCIABILIDADE OU
ADEQUACAO A UMA FINALIDADE ESPECIFICA. Consulte a Licenca Publica Geral do
GNU versao 2 para mais detalhes.

Voce deve ter recebido uma copia da Licenca Publica Geral do GNU versao 2 junto
com este programa; se nao, escreva para a Free Software Foundation, Inc., no
endereco 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.

Para maiores informacoes:
ncl @ telemidia.puc-rio.br
http://www.ncl.org.br
http://www.ginga.org.br
http://www.telemidia.puc-rio.br
******************************************************************************
This file is part of the declarative environment of middleware Ginga (Ginga-NCL)

Copyright: 1989-2007 PUC-RIO/LABORATORIO TELEMIDIA, All Rights Reserved.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License version 2 as published by
the Free Software Foundation.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License version 2 for more
details.

You should have received a copy of the GNU General Public License version 2
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

For further information contact:
ncl @ telemidia.puc-rio.br
http://www.ncl.org.br
http://www.ginga.org.br
http://www.telemidia.puc-rio.br
*******************************************************************************/

#ifndef SDLAUDIOPROVIDER_H_
#define SDLAUDIOPROVIDER_H_

#include "mb/interface/IContinuousMediaProvider.h"

#include "SDL2ffmpeg.h"

#include <set>
using namespace std;

namespace br {
namespace pucrio {
namespace telemidia {
namespace ginga {
namespace core {
namespace mb {
	class SDLAudioProvider : public IContinuousMediaProvider {
		protected:
			GingaScreenID myScreen;
			string symbol;
			string mrl;

			SDL2ffmpeg* decoder;

		public:
			SDLAudioProvider(GingaScreenID screenId, const char* mrl);
			virtual ~SDLAudioProvider();

			virtual void setLoadSymbol(string symbol);
			virtual string getLoadSymbol();

			virtual bool getHasVisual(){return false;};

			virtual void setAVPid(int aPid, int vPid){};
			virtual void feedBuffers(){};
			void* getProviderContent();
			virtual void setProviderContent(void* content){};
			virtual bool checkVideoResizeEvent(GingaSurfaceID frame){return false;};
			double getTotalMediaTime();
			float getSoundLevel();
			virtual int64_t getVPts();
			double getMediaTime();
			void setMediaTime(double pos);

		public:
			void playOver(GingaSurfaceID surface);
			void resume(GingaSurfaceID surface);
			void pause();
			void stop();
			void setSoundLevel(float level);
			bool releaseAll();
			void getOriginalResolution(int* width, int* height);

			virtual void refreshDR(void* data);
	};
}
}
}
}
}
}

#endif /*SDLAUDIOPROVIDER_H_*/
