#!/bin/bash
# Script by Rafael Diniz <rafael@riseup.net>
#
# License: General Public License version 3.
# https://www.gnu.org/licenses/gpl-3.0.html

TIME_CMD=/usr/bin/time
INPUT_DIR=images_input/
OUTPUT_DIR=images_output/
METRICS=metrics/
NUMBERS=" 5 15 25 35 45 55 65 75 85 "

for i in $( ls $INPUT_DIR ); do
  echo item: $i

  for quality in `echo $NUMBERS`; do
    echo Quality is $quality
#    ./jo_jpeg $INPUT_DIR$$i
    ./jo_jpeg $INPUT_DIR$i $OUTPUT_DIR$i-trab-$quality.jpg $quality
    # /opt/mozjpeg/bin/cjpeg -grayscale -baseline -tune-psnr -optimize -quality $(($quality + 10)) -outfile $OUTPUT_DIR$i-ref-$quality.jpg $INPUT_DIR$i 
    /opt/mozjpeg/bin/cjpeg -grayscale -baseline -tune-psnr -optimize -quality $quality -outfile $OUTPUT_DIR$i-ref-$quality.jpg $INPUT_DIR$i 
    qpsnr -o colorspace=y -a psnr -r $INPUT_DIR$i $OUTPUT_DIR$i-ref-$quality.jpg $OUTPUT_DIR$i-trab-$quality.jpg > $METRICS$i-$quality.psnr
    qpsnr -o colorspace=y:blocksize=8 -a ssim -r $INPUT_DIR$i $OUTPUT_DIR$i-ref-$quality.jpg $OUTPUT_DIR$i-trab-$quality.jpg > $METRICS$i-$quality.ssim
#     qpsnr -o colorspace=y -a psnr -r $INPUT_DIR$i $OUTPUT_DIR$i-ref-$quality.jpg > $METRICS$i-ref-$quality.psnr
    # let "COUNTER=COUNTER+10"
  done
done
