/*
 * Decompiled with CFR 0.152.
 */
package javaPlay;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.image.BufferStrategy;
import javax.swing.JFrame;

public class GameCanvas
extends JFrame {
    private final int defaultScreenWidth = 1280;
    private final int defaultScreenHeight = 720;
    private final Boolean fullscreen = true;
    private Graphics g;
    private BufferStrategy bf;
    private int renderScreenStartX;
    private int renderScreenStartY;

    public GameCanvas(GraphicsConfiguration gc) {
        super(gc);
        if (this.fullscreen.booleanValue()) {
            this.setUndecorated(true);
        }
        this.setResizable(false);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
        this.setSize(1280, 720);
        if (this.fullscreen.booleanValue()) {
            GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(this);
        }
        this.setIgnoreRepaint(true);
        this.createBufferStrategy(2);
        this.renderScreenStartX = this.getContentPane().getLocationOnScreen().x;
        this.renderScreenStartY = this.getContentPane().getLocationOnScreen().y;
        this.bf = this.getBufferStrategy();
    }

    public int getRenderScreenStartX() {
        return this.renderScreenStartX;
    }

    public int getRenderScreenStartY() {
        return this.renderScreenStartY;
    }

    public Graphics getGameGraphics() {
        this.g = this.bf.getDrawGraphics();
        return this.g;
    }

    public void swapBuffers() {
        this.bf.show();
        this.g.dispose();
        Toolkit.getDefaultToolkit().sync();
    }
}

