/*
 * Decompiled with CFR 0.152.
 */
package javaPlay;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javaPlay.GameCanvas;
import javaPlay.GameStateController;
import javaPlay.Keyboard;
import javaPlay.Mouse;

public class GameEngine {
    public int TARGET_FPS = 60;
    private GameCanvas canvas;
    private Mouse mouse;
    private Keyboard keyboard;
    private long lastTime;
    private boolean engineRunning;
    private Hashtable gameStateControllers;
    private GameStateController currGameState;
    private GameStateController nextGameState;
    private static GameEngine instance;

    private GameEngine() {
        GraphicsEnvironment graphEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphDevice = graphEnv.getDefaultScreenDevice();
        GraphicsConfiguration graphicConf = graphDevice.getDefaultConfiguration();
        this.canvas = new GameCanvas(graphicConf);
        this.mouse = new Mouse();
        this.keyboard = new Keyboard();
        this.canvas.addMouseListener(this.mouse);
        this.canvas.addMouseMotionListener(this.mouse);
        this.canvas.addKeyListener(this.keyboard);
        this.lastTime = System.currentTimeMillis();
        this.engineRunning = true;
        this.gameStateControllers = new Hashtable();
        this.currGameState = null;
        this.nextGameState = null;
        instance = null;
    }

    public static GameEngine getInstance() {
        if (instance == null) {
            instance = new GameEngine();
        }
        return instance;
    }

    public GameCanvas getGameCanvas() {
        return this.canvas;
    }

    public Mouse getMouse() {
        return this.mouse;
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    public void addGameStateController(int id, GameStateController gs) {
        this.gameStateControllers.put(id, gs);
        gs.load();
    }

    public void removeGameStateController(int id) {
        GameStateController gs = (GameStateController)this.gameStateControllers.get(id);
        gs.unload();
    }

    public void setStartingGameStateController(int id) {
        this.currGameState = (GameStateController)this.gameStateControllers.get(id);
    }

    public void setNextGameStateController(int id) {
        this.nextGameState = (GameStateController)this.gameStateControllers.get(id);
    }

    public void requestShutdown() {
        this.engineRunning = false;
    }

    public void run() {
        if (this.currGameState == null) {
            return;
        }
        this.currGameState.start();
        long lastLoopTime = System.currentTimeMillis();
        int wait_time = 1000 / this.TARGET_FPS;
        while (this.engineRunning) {
            long sleep_time;
            long delta = System.currentTimeMillis() - lastLoopTime;
            lastLoopTime = System.currentTimeMillis();
            this.currGameState.step(delta);
            this.currGameState.draw(this.canvas.getGameGraphics());
            this.canvas.swapBuffers();
            if (this.nextGameState != null) {
                this.currGameState.stop();
                this.nextGameState.start();
                this.currGameState = this.nextGameState;
                this.nextGameState = null;
            }
            if ((sleep_time = lastLoopTime + (long)wait_time - System.currentTimeMillis()) <= 0L) continue;
            try {
                Thread.sleep(sleep_time);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(GameEngine.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.canvas.dispose();
    }
}

