/*
 * Decompiled with CFR 0.152.
 */
package dinabodic;

import dinabodic.EnemyFire;
import dinabodic.Player;
import dinabodic.SimpleController;
import java.awt.Graphics;
import java.util.Random;
import javaPlay.GameEngine;
import javaPlay.GameObject;
import javaPlay.Scene;
import javaPlay.Sprite;

public class Enemy
extends GameObject {
    private Sprite sprite;
    private Sprite fireSprite;
    private Player player;
    private SimpleController controller;
    private Scene scene;
    private Random random = new Random();
    private long timeCalled = 0L;

    public void setController(SimpleController controller) {
        this.controller = controller;
    }

    public void setSprite(Sprite sprite, Sprite fireSprite) {
        this.sprite = sprite;
        this.fireSprite = fireSprite;
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void setStartPoint(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void step(long timeElapsed) {
        --this.x;
        if (this.player.x < this.x) {
            if (this.player.y - 192 < this.y) {
                --this.y;
            }
            if (this.player.y + 192 > this.y) {
                ++this.y;
            }
        }
        if (this.x < 0) {
            this.x = 1280;
        }
        ++this.timeCalled;
        if (this.timeCalled > (long)(4 * GameEngine.getInstance().TARGET_FPS)) {
            this.timeCalled = 0L;
            EnemyFire fire = new EnemyFire(this.fireSprite);
            fire.x = this.x;
            fire.y = this.y;
            this.controller.addEnemyFire(fire);
            this.scene.addOverlay(fire);
        }
    }

    public void draw(Graphics g) {
        this.sprite.setCurrAnimFrame(0);
        this.sprite.draw(g, this.x, this.y);
    }
}

