/*
 * Decompiled with CFR 0.152.
 */
package dinabodic;

import dinabodic.PlayerFire;
import java.awt.Graphics;
import java.util.ArrayList;
import javaPlay.GameObject;
import javaPlay.Scene;
import javaPlay.Sprite;
import javax.sound.sampled.Clip;

public class Player
extends GameObject {
    public int startX = 32;
    public int startY = 32;
    private Sprite sprite;
    private Sprite fireSprite;
    private Scene scene;
    private int currFrame;
    private ArrayList fires;
    private Clip fireClip;
    private final int[] UP_FRAMES = new int[]{0, 4, 5, 6};
    private final int[] LEFT_FRAMES = new int[]{0};
    private final int[] RIGHT_FRAMES = new int[]{0};
    private final int[] DOWN_FRAMES = new int[]{0, 1, 2, 3};
    private final int SHOW_STEP = 10;
    private int animIndex;
    private int currMoveAnim;
    private int stepCounter;
    long lastFireTime;
    private final int MOVE_ANIM_UP = 0;
    private final int MOVE_ANIM_DOWN = 1;
    private final int MOVE_ANIM_LEFT = 2;
    private final int MOVE_ANIM_RIGHT = 3;
    private final int MOVE_ANIM_IDLE = 4;

    public void setSprite(Sprite sprite, Sprite fireSprite) {
        this.sprite = sprite;
        this.fireSprite = fireSprite;
        this.animIndex = 0;
        this.currFrame = this.UP_FRAMES[this.animIndex];
        this.currMoveAnim = 0;
        this.stepCounter = 0;
        this.fires = new ArrayList();
    }

    public void setClip(Clip clip) {
        this.fireClip = clip;
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    public ArrayList getFire() {
        if (this.fires != null) {
            return this.fires;
        }
        return null;
    }

    public void moveUp() {
        --this.y;
        --this.y;
        this.currMoveAnim = 0;
    }

    public void moveDown() {
        ++this.y;
        ++this.y;
        this.currMoveAnim = 1;
    }

    public void moveLeft() {
        --this.x;
        --this.x;
        this.currMoveAnim = 2;
    }

    public void moveRight() {
        ++this.x;
        ++this.x;
        this.currMoveAnim = 3;
    }

    public void moveIdle() {
        this.currMoveAnim = 4;
    }

    public void fire() {
        long currentFireTime = System.currentTimeMillis();
        if (currentFireTime - this.lastFireTime > 500L) {
            PlayerFire fire = new PlayerFire(this.fireSprite);
            fire.x = this.x + 48;
            fire.y = this.y + 32;
            this.fires.add(fire);
            this.scene.addOverlay(fire);
            if (this.fireClip.isRunning()) {
                this.fireClip.stop();
            }
            this.fireClip.setFramePosition(0);
            this.fireClip.start();
        }
        this.lastFireTime = currentFireTime;
    }

    public void step(long timeElapsed) {
        switch (this.currMoveAnim) {
            case 0: {
                if (++this.stepCounter < 10) break;
                ++this.animIndex;
                if (this.animIndex >= this.UP_FRAMES.length) {
                    this.animIndex = this.UP_FRAMES.length - 1;
                }
                this.currFrame = this.UP_FRAMES[this.animIndex];
                this.stepCounter = 0;
                break;
            }
            case 1: {
                if (++this.stepCounter < 10) break;
                ++this.animIndex;
                if (this.animIndex >= this.DOWN_FRAMES.length) {
                    this.animIndex = this.DOWN_FRAMES.length - 1;
                }
                this.currFrame = this.DOWN_FRAMES[this.animIndex];
                this.stepCounter = 0;
                break;
            }
            case 2: {
                if (++this.stepCounter < 10) break;
                ++this.animIndex;
                if (this.animIndex >= this.LEFT_FRAMES.length) {
                    this.animIndex = this.LEFT_FRAMES.length - 1;
                }
                this.currFrame = this.LEFT_FRAMES[this.animIndex];
                this.stepCounter = 0;
                break;
            }
            case 3: {
                if (++this.stepCounter < 10) break;
                ++this.animIndex;
                if (this.animIndex >= this.RIGHT_FRAMES.length) {
                    this.animIndex = this.RIGHT_FRAMES.length - 1;
                }
                this.currFrame = this.RIGHT_FRAMES[this.animIndex];
                this.stepCounter = 0;
                break;
            }
            case 4: {
                if (++this.stepCounter < 10) break;
                this.animIndex = 0;
                this.currFrame = this.UP_FRAMES[this.animIndex];
                this.stepCounter = 0;
            }
        }
    }

    public void draw(Graphics g) {
        this.sprite.setCurrAnimFrame(this.currFrame);
        this.sprite.draw(g, this.x, this.y);
    }
}

