/*
 * Decompiled with CFR 0.152.
 */
package dinabodic;

import dinabodic.Enemy;
import dinabodic.EnemyFire;
import dinabodic.Explosion;
import dinabodic.Player;
import dinabodic.PlayerFire;
import dinabodic.Score;
import java.awt.Graphics;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javaPlay.GameEngine;
import javaPlay.GameStateController;
import javaPlay.Keyboard;
import javaPlay.Scene;
import javaPlay.Sprite;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;

public class SimpleController
implements GameStateController {
    private Sprite playerSprite;
    private Sprite playerFireSprite;
    private Sprite enemySprite;
    private Sprite enemyFireSprite;
    private Sprite explosionEnemySprite;
    private Sprite explosionPlayerSprite;
    private Player player;
    private Clip backgroundClip;
    private Clip explosionClip;
    private ArrayList enemies;
    private ArrayList enemiesInactive;
    private ArrayList enemiesFire;
    private ArrayList explosions;
    private Scene scene;
    private int numberOfEnemies = 12;
    private final int TILE_WALL = 1;
    private final int TILE_EXIT = 3;
    private int[] midx;
    private int[] midy;
    private final int UP_MID = 0;
    private final int DOWN_MID = 1;
    private final int LEFT_MID = 2;
    private final int RIGHT_MID = 3;
    private Score score;

    public void load() {
        try {
            AudioInputStream audioInputStream;
            this.playerSprite = new Sprite("mainship", 7, 128, 72, true);
            this.playerFireSprite = new Sprite("missil_player.png", 1, 57, 32);
            this.enemyFireSprite = new Sprite("tiro_enemy.png", 1, 44, 25);
            this.explosionEnemySprite = new Sprite("explosionlo", 5, 171, 96, true);
            this.explosionPlayerSprite = new Sprite("explosionhi", 5, 228, 128, true);
            this.scene = new Scene();
            this.scene.loadFromFile("scene.scn");
            this.player = new Player();
            this.player.setSprite(this.playerSprite, this.playerFireSprite);
            this.player.setScene(this.scene);
            this.scene.addOverlay(this.player);
            this.enemies = new ArrayList();
            this.enemiesInactive = new ArrayList();
            this.enemiesFire = new ArrayList();
            this.explosions = new ArrayList();
            for (int i = 1; i <= this.numberOfEnemies; ++i) {
                this.enemySprite = new Sprite("enemy-" + i + ".png", 1, 114, 64);
                Enemy enemy = new Enemy();
                enemy.setSprite(this.enemySprite, this.enemyFireSprite);
                enemy.setScene(this.scene);
                enemy.setPlayer(this.player);
                enemy.setController(this);
                enemy.setStartPoint(1280, i * 128 % 592);
                this.enemiesInactive.add(enemy);
            }
            this.score = new Score();
            this.scene.addOverlay(this.score);
            this.midx = new int[4];
            this.midy = new int[4];
            Clip fireClip = null;
            try {
                audioInputStream = AudioSystem.getAudioInputStream(new File("tiro.wav").getAbsoluteFile());
                fireClip = AudioSystem.getClip();
                fireClip.open(audioInputStream);
            }
            catch (Exception ex) {
                System.out.println("Error with playing sound.");
                ex.printStackTrace();
            }
            this.player.setClip(fireClip);
            try {
                audioInputStream = AudioSystem.getAudioInputStream(new File("explosion.wav").getAbsoluteFile());
                this.explosionClip = AudioSystem.getClip();
                this.explosionClip.open(audioInputStream);
            }
            catch (Exception ex) {
                System.out.println("Error with playing sound.");
                ex.printStackTrace();
            }
            try {
                audioInputStream = AudioSystem.getAudioInputStream(new File("trilha.wav").getAbsoluteFile());
                this.backgroundClip = AudioSystem.getClip();
                this.backgroundClip.open(audioInputStream);
            }
            catch (Exception ex) {
                System.out.println("Error with playing sound.");
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(SimpleController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void unload() {
    }

    public void start() {
        this.player.x = this.player.startX;
        this.player.y = this.player.startY;
        this.backgroundClip.loop(-1);
    }

    public void step(long timeElapsed) {
        int i;
        Keyboard k = GameEngine.getInstance().getKeyboard();
        if (!(k.keyDown(38) || k.keyDown(40) || k.keyDown(37) || k.keyDown(39))) {
            this.player.moveIdle();
        }
        if (k.keyDown(37)) {
            this.player.moveLeft();
        }
        if (k.keyDown(39)) {
            this.player.moveRight();
        }
        if (k.keyDown(38)) {
            this.player.moveUp();
        }
        if (k.keyDown(40)) {
            this.player.moveDown();
        }
        if (k.keyDown(32)) {
            this.player.fire();
        }
        if (this.numberOfEnemies == 0 && this.explosions.size() == 0) {
            this.backgroundClip.stop();
            GameEngine.getInstance().setNextGameStateController(2);
        }
        if (this.enemies.size() < 4 && this.enemiesInactive.size() > 0) {
            Enemy enemy = (Enemy)this.enemiesInactive.get(0);
            this.enemies.add(enemy);
            this.scene.addOverlay(enemy);
            this.enemiesInactive.remove(enemy);
        }
        for (int i2 = 0; i2 < this.explosions.size(); ++i2) {
            Explosion explosion = (Explosion)this.explosions.get(i2);
            explosion.step(300L);
            if (!explosion.explosionEnded().booleanValue()) continue;
            this.explosions.remove(explosion);
        }
        this.player.step(timeElapsed);
        Point playerMin = new Point(this.player.x + 20, this.player.y + 10);
        Point playerMax = new Point(this.player.x + 96, this.player.y + 48);
        for (i = 0; i < this.enemiesFire.size(); ++i) {
            Point fireMin = null;
            Point fireMax = null;
            EnemyFire fire = (EnemyFire)this.enemiesFire.get(i);
            fire.step(timeElapsed);
            fireMin = new Point(fire.x, fire.y);
            fireMax = new Point(fire.x + 16, fire.y + 16);
            if (this.isColliding(playerMin, playerMax, fireMin, fireMax)) {
                Explosion explosion = new Explosion();
                explosion.x = this.player.x;
                explosion.y = this.player.y;
                explosion.setSprite(this.explosionPlayerSprite);
                explosion.setScene(this.scene);
                this.explosions.add(explosion);
                this.scene.addOverlay(explosion);
                this.score.decLife();
                this.player.x = this.player.startX;
                this.player.y = this.player.startY;
                if (this.explosionClip.isRunning()) {
                    this.explosionClip.stop();
                }
                this.explosionClip.setFramePosition(0);
                this.explosionClip.start();
                if (this.score.getLife() == 0) {
                    this.backgroundClip.stop();
                    GameEngine.getInstance().setNextGameStateController(2);
                }
                return;
            }
            if (fire.x >= -32 && fire.y >= -32) continue;
            this.scene.removeOverlay(fire);
            this.enemiesFire.remove(fire);
            fire = null;
        }
        for (i = 0; i < this.enemies.size(); ++i) {
            Enemy enemy = (Enemy)this.enemies.get(i);
            enemy.step(timeElapsed);
            Point enemyMin = new Point(enemy.x, enemy.y);
            Point enemyMax = new Point(enemy.x + 31, enemy.y + 31);
            if (!this.isColliding(playerMin, playerMax, enemyMin, enemyMax)) continue;
            Explosion explosion = new Explosion();
            explosion.x = this.player.x;
            explosion.y = this.player.y;
            explosion.setSprite(this.explosionPlayerSprite);
            explosion.setScene(this.scene);
            this.explosions.add(explosion);
            this.scene.addOverlay(explosion);
            this.score.decLife();
            this.player.x = this.player.startX;
            this.player.y = this.player.startY;
            if (this.explosionClip.isRunning()) {
                this.explosionClip.stop();
            }
            this.explosionClip.setFramePosition(0);
            this.explosionClip.start();
            if (this.score.getLife() == 0) {
                this.backgroundClip.stop();
                GameEngine.getInstance().setNextGameStateController(2);
            }
            return;
        }
        ArrayList playerFire = null;
        playerFire = this.player.getFire();
        if (playerFire != null) {
            for (int i3 = 0; i3 < playerFire.size(); ++i3) {
                PlayerFire fire = (PlayerFire)playerFire.get(i3);
                fire.step(0L);
                if (fire.x > 1280 || fire.y > 720) {
                    this.scene.removeOverlay(fire);
                    playerFire.remove(fire);
                    fire = null;
                    continue;
                }
                Point fireMin = new Point(fire.x, fire.y);
                Point fireMax = new Point(fire.x + 15, fire.y + 15);
                for (int j = 0; j < this.enemies.size(); ++j) {
                    Enemy enemy = (Enemy)this.enemies.get(j);
                    Point enemyMin = new Point(enemy.x, enemy.y);
                    Point enemyMax = new Point(enemy.x + 31, enemy.y + 31);
                    if (!this.isColliding(enemyMin, enemyMax, fireMin, fireMax)) continue;
                    Explosion explosion = new Explosion();
                    explosion.x = enemy.x;
                    explosion.y = enemy.y;
                    explosion.setSprite(this.explosionEnemySprite);
                    explosion.setScene(this.scene);
                    this.explosions.add(explosion);
                    this.score.setScore(5);
                    this.scene.removeOverlay(enemy);
                    this.enemies.remove(enemy);
                    --this.numberOfEnemies;
                    this.scene.removeOverlay(fire);
                    playerFire.remove(fire);
                    this.scene.addOverlay(explosion);
                    if (this.explosionClip.isRunning()) {
                        this.explosionClip.stop();
                    }
                    this.explosionClip.setFramePosition(0);
                    this.explosionClip.start();
                    fire = null;
                    enemy = null;
                }
            }
        }
    }

    public void draw(Graphics g) {
        this.scene.draw(g);
    }

    public void stop() {
    }

    public void addEnemyFire(EnemyFire enemyFire) {
        this.enemiesFire.add(enemyFire);
    }

    public void removeEnemyFire(EnemyFire enemyFire) {
        this.enemiesFire.remove(enemyFire);
        enemyFire = null;
    }

    private boolean isColliding(Point min1, Point max1, Point min2, Point max2) {
        if (min1.x > max2.x || max1.x < min2.x) {
            return false;
        }
        return min1.y <= max2.y && max1.y >= min2.y;
    }
}

